import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendSignConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of alternative names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#alt_names PkiSecretBackendSign#alt_names}
    */
    readonly altNames?: string[];
    /**
    * If enabled, a new certificate will be generated if the expiration is within min_seconds_remaining
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#auto_renew PkiSecretBackendSign#auto_renew}
    */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#backend PkiSecretBackendSign#backend}
    */
    readonly backend: string;
    /**
    * CN of intermediate to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#common_name PkiSecretBackendSign#common_name}
    */
    readonly commonName: string;
    /**
    * The CSR.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#csr PkiSecretBackendSign#csr}
    */
    readonly csr: string;
    /**
    * Flag to exclude CN from SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#exclude_cn_from_sans PkiSecretBackendSign#exclude_cn_from_sans}
    */
    readonly excludeCnFromSans?: boolean | cdktf.IResolvable;
    /**
    * The format of data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#format PkiSecretBackendSign#format}
    */
    readonly format?: string;
    /**
    * List of alternative IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#ip_sans PkiSecretBackendSign#ip_sans}
    */
    readonly ipSans?: string[];
    /**
    * Generate a new certificate when the expiration is within this number of seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#min_seconds_remaining PkiSecretBackendSign#min_seconds_remaining}
    */
    readonly minSecondsRemaining?: number;
    /**
    * Name of the role to create the certificate against.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#name PkiSecretBackendSign#name}
    */
    readonly name: string;
    /**
    * List of other SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#other_sans PkiSecretBackendSign#other_sans}
    */
    readonly otherSans?: string[];
    /**
    * Time to live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#ttl PkiSecretBackendSign#ttl}
    */
    readonly ttl?: string;
    /**
    * List of alternative URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign#uri_sans PkiSecretBackendSign#uri_sans}
    */
    readonly uriSans?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign vault_pki_secret_backend_sign}
*/
export declare class PkiSecretBackendSign extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_sign";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_sign vault_pki_secret_backend_sign} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendSignConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendSignConfig);
    private _altNames?;
    get altNames(): string[];
    set altNames(value: string[]);
    resetAltNames(): void;
    get altNamesInput(): string[] | undefined;
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    resetAutoRenew(): void;
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get caChain(): string[];
    get certificate(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _csr?;
    get csr(): string;
    set csr(value: string);
    get csrInput(): string | undefined;
    private _excludeCnFromSans?;
    get excludeCnFromSans(): boolean | cdktf.IResolvable;
    set excludeCnFromSans(value: boolean | cdktf.IResolvable);
    resetExcludeCnFromSans(): void;
    get excludeCnFromSansInput(): boolean | cdktf.IResolvable | undefined;
    get expiration(): number;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    get id(): string;
    private _ipSans?;
    get ipSans(): string[];
    set ipSans(value: string[]);
    resetIpSans(): void;
    get ipSansInput(): string[] | undefined;
    get issuingCa(): string;
    private _minSecondsRemaining?;
    get minSecondsRemaining(): number;
    set minSecondsRemaining(value: number);
    resetMinSecondsRemaining(): void;
    get minSecondsRemainingInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _otherSans?;
    get otherSans(): string[];
    set otherSans(value: string[]);
    resetOtherSans(): void;
    get otherSansInput(): string[] | undefined;
    get serial(): string;
    get serialNumber(): string;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string[];
    set uriSans(value: string[]);
    resetUriSans(): void;
    get uriSansInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-sign.d.ts.map