import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag to allow any name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_any_name PkiSecretBackendRole#allow_any_name}
    */
    readonly allowAnyName?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow certificates matching the actual domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_bare_domains PkiSecretBackendRole#allow_bare_domains}
    */
    readonly allowBareDomains?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow names containing glob patterns.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_glob_domains PkiSecretBackendRole#allow_glob_domains}
    */
    readonly allowGlobDomains?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow IP SANs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_ip_sans PkiSecretBackendRole#allow_ip_sans}
    */
    readonly allowIpSans?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow certificates for localhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_localhost PkiSecretBackendRole#allow_localhost}
    */
    readonly allowLocalhost?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow certificates matching subdomains.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allow_subdomains PkiSecretBackendRole#allow_subdomains}
    */
    readonly allowSubdomains?: boolean | cdktf.IResolvable;
    /**
    * The domains of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allowed_domains PkiSecretBackendRole#allowed_domains}
    */
    readonly allowedDomains?: string[];
    /**
    * Flag to indicate that `allowed_domains` specifies a template expression (e.g. {{identity.entity.aliases.<mount accessor>.name}})
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allowed_domains_template PkiSecretBackendRole#allowed_domains_template}
    */
    readonly allowedDomainsTemplate?: boolean | cdktf.IResolvable;
    /**
    * Defines allowed custom SANs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allowed_other_sans PkiSecretBackendRole#allowed_other_sans}
    */
    readonly allowedOtherSans?: string[];
    /**
    * Defines allowed Subject serial numbers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allowed_serial_numbers PkiSecretBackendRole#allowed_serial_numbers}
    */
    readonly allowedSerialNumbers?: string[];
    /**
    * Defines allowed URI SANs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#allowed_uri_sans PkiSecretBackendRole#allowed_uri_sans}
    */
    readonly allowedUriSans?: string[];
    /**
    * The path of the PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#backend PkiSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Flag to mark basic constraints valid when issuing non-CA certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#basic_constraints_valid_for_non_ca PkiSecretBackendRole#basic_constraints_valid_for_non_ca}
    */
    readonly basicConstraintsValidForNonCa?: boolean | cdktf.IResolvable;
    /**
    * Flag to specify certificates for client use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#client_flag PkiSecretBackendRole#client_flag}
    */
    readonly clientFlag?: boolean | cdktf.IResolvable;
    /**
    * Flag to specify certificates for code signing use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#code_signing_flag PkiSecretBackendRole#code_signing_flag}
    */
    readonly codeSigningFlag?: boolean | cdktf.IResolvable;
    /**
    * The country of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#country PkiSecretBackendRole#country}
    */
    readonly country?: string[];
    /**
    * Flag to specify certificates for email protection use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#email_protection_flag PkiSecretBackendRole#email_protection_flag}
    */
    readonly emailProtectionFlag?: boolean | cdktf.IResolvable;
    /**
    * Flag to allow only valid host names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#enforce_hostnames PkiSecretBackendRole#enforce_hostnames}
    */
    readonly enforceHostnames?: boolean | cdktf.IResolvable;
    /**
    * Specify the allowed extended key usage constraint on issued certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#ext_key_usage PkiSecretBackendRole#ext_key_usage}
    */
    readonly extKeyUsage?: string[];
    /**
    * Flag to generate leases with certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#generate_lease PkiSecretBackendRole#generate_lease}
    */
    readonly generateLease?: boolean | cdktf.IResolvable;
    /**
    * The number of bits of generated keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#key_bits PkiSecretBackendRole#key_bits}
    */
    readonly keyBits?: number;
    /**
    * The generated key type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#key_type PkiSecretBackendRole#key_type}
    */
    readonly keyType?: string;
    /**
    * Specify the allowed key usage constraint on issued certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#key_usage PkiSecretBackendRole#key_usage}
    */
    readonly keyUsage?: string[];
    /**
    * The locality of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#locality PkiSecretBackendRole#locality}
    */
    readonly locality?: string[];
    /**
    * The maximum TTL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#max_ttl PkiSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#name PkiSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Flag to not store certificates in the storage backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#no_store PkiSecretBackendRole#no_store}
    */
    readonly noStore?: boolean | cdktf.IResolvable;
    /**
    * Specifies the duration by which to backdate the NotBefore property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#not_before_duration PkiSecretBackendRole#not_before_duration}
    */
    readonly notBeforeDuration?: string;
    /**
    * The organization of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#organization PkiSecretBackendRole#organization}
    */
    readonly organization?: string[];
    /**
    * The organization unit of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#ou PkiSecretBackendRole#ou}
    */
    readonly ou?: string[];
    /**
    * Specify the list of allowed policies IODs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#policy_identifiers PkiSecretBackendRole#policy_identifiers}
    */
    readonly policyIdentifiers?: string[];
    /**
    * The postal code of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#postal_code PkiSecretBackendRole#postal_code}
    */
    readonly postalCode?: string[];
    /**
    * The province of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#province PkiSecretBackendRole#province}
    */
    readonly province?: string[];
    /**
    * Flag to force CN usage.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#require_cn PkiSecretBackendRole#require_cn}
    */
    readonly requireCn?: boolean | cdktf.IResolvable;
    /**
    * Flag to specify certificates for server use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#server_flag PkiSecretBackendRole#server_flag}
    */
    readonly serverFlag?: boolean | cdktf.IResolvable;
    /**
    * The street address of generated certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#street_address PkiSecretBackendRole#street_address}
    */
    readonly streetAddress?: string[];
    /**
    * The TTL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#ttl PkiSecretBackendRole#ttl}
    */
    readonly ttl?: string;
    /**
    * Flag to use the CN in the CSR.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#use_csr_common_name PkiSecretBackendRole#use_csr_common_name}
    */
    readonly useCsrCommonName?: boolean | cdktf.IResolvable;
    /**
    * Flag to use the SANs in the CSR.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role#use_csr_sans PkiSecretBackendRole#use_csr_sans}
    */
    readonly useCsrSans?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role vault_pki_secret_backend_role}
*/
export declare class PkiSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_role vault_pki_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendRoleConfig);
    private _allowAnyName?;
    get allowAnyName(): boolean | cdktf.IResolvable;
    set allowAnyName(value: boolean | cdktf.IResolvable);
    resetAllowAnyName(): void;
    get allowAnyNameInput(): boolean | cdktf.IResolvable | undefined;
    private _allowBareDomains?;
    get allowBareDomains(): boolean | cdktf.IResolvable;
    set allowBareDomains(value: boolean | cdktf.IResolvable);
    resetAllowBareDomains(): void;
    get allowBareDomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGlobDomains?;
    get allowGlobDomains(): boolean | cdktf.IResolvable;
    set allowGlobDomains(value: boolean | cdktf.IResolvable);
    resetAllowGlobDomains(): void;
    get allowGlobDomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowIpSans?;
    get allowIpSans(): boolean | cdktf.IResolvable;
    set allowIpSans(value: boolean | cdktf.IResolvable);
    resetAllowIpSans(): void;
    get allowIpSansInput(): boolean | cdktf.IResolvable | undefined;
    private _allowLocalhost?;
    get allowLocalhost(): boolean | cdktf.IResolvable;
    set allowLocalhost(value: boolean | cdktf.IResolvable);
    resetAllowLocalhost(): void;
    get allowLocalhostInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubdomains?;
    get allowSubdomains(): boolean | cdktf.IResolvable;
    set allowSubdomains(value: boolean | cdktf.IResolvable);
    resetAllowSubdomains(): void;
    get allowSubdomainsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedDomains?;
    get allowedDomains(): string[];
    set allowedDomains(value: string[]);
    resetAllowedDomains(): void;
    get allowedDomainsInput(): string[] | undefined;
    private _allowedDomainsTemplate?;
    get allowedDomainsTemplate(): boolean | cdktf.IResolvable;
    set allowedDomainsTemplate(value: boolean | cdktf.IResolvable);
    resetAllowedDomainsTemplate(): void;
    get allowedDomainsTemplateInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedOtherSans?;
    get allowedOtherSans(): string[];
    set allowedOtherSans(value: string[]);
    resetAllowedOtherSans(): void;
    get allowedOtherSansInput(): string[] | undefined;
    private _allowedSerialNumbers?;
    get allowedSerialNumbers(): string[];
    set allowedSerialNumbers(value: string[]);
    resetAllowedSerialNumbers(): void;
    get allowedSerialNumbersInput(): string[] | undefined;
    private _allowedUriSans?;
    get allowedUriSans(): string[];
    set allowedUriSans(value: string[]);
    resetAllowedUriSans(): void;
    get allowedUriSansInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _basicConstraintsValidForNonCa?;
    get basicConstraintsValidForNonCa(): boolean | cdktf.IResolvable;
    set basicConstraintsValidForNonCa(value: boolean | cdktf.IResolvable);
    resetBasicConstraintsValidForNonCa(): void;
    get basicConstraintsValidForNonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _clientFlag?;
    get clientFlag(): boolean | cdktf.IResolvable;
    set clientFlag(value: boolean | cdktf.IResolvable);
    resetClientFlag(): void;
    get clientFlagInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigningFlag?;
    get codeSigningFlag(): boolean | cdktf.IResolvable;
    set codeSigningFlag(value: boolean | cdktf.IResolvable);
    resetCodeSigningFlag(): void;
    get codeSigningFlagInput(): boolean | cdktf.IResolvable | undefined;
    private _country?;
    get country(): string[];
    set country(value: string[]);
    resetCountry(): void;
    get countryInput(): string[] | undefined;
    private _emailProtectionFlag?;
    get emailProtectionFlag(): boolean | cdktf.IResolvable;
    set emailProtectionFlag(value: boolean | cdktf.IResolvable);
    resetEmailProtectionFlag(): void;
    get emailProtectionFlagInput(): boolean | cdktf.IResolvable | undefined;
    private _enforceHostnames?;
    get enforceHostnames(): boolean | cdktf.IResolvable;
    set enforceHostnames(value: boolean | cdktf.IResolvable);
    resetEnforceHostnames(): void;
    get enforceHostnamesInput(): boolean | cdktf.IResolvable | undefined;
    private _extKeyUsage?;
    get extKeyUsage(): string[];
    set extKeyUsage(value: string[]);
    resetExtKeyUsage(): void;
    get extKeyUsageInput(): string[] | undefined;
    private _generateLease?;
    get generateLease(): boolean | cdktf.IResolvable;
    set generateLease(value: boolean | cdktf.IResolvable);
    resetGenerateLease(): void;
    get generateLeaseInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _keyBits?;
    get keyBits(): number;
    set keyBits(value: number);
    resetKeyBits(): void;
    get keyBitsInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _keyUsage?;
    get keyUsage(): string[];
    set keyUsage(value: string[]);
    resetKeyUsage(): void;
    get keyUsageInput(): string[] | undefined;
    private _locality?;
    get locality(): string[];
    set locality(value: string[]);
    resetLocality(): void;
    get localityInput(): string[] | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _noStore?;
    get noStore(): boolean | cdktf.IResolvable;
    set noStore(value: boolean | cdktf.IResolvable);
    resetNoStore(): void;
    get noStoreInput(): boolean | cdktf.IResolvable | undefined;
    private _notBeforeDuration?;
    get notBeforeDuration(): string;
    set notBeforeDuration(value: string);
    resetNotBeforeDuration(): void;
    get notBeforeDurationInput(): string | undefined;
    private _organization?;
    get organization(): string[];
    set organization(value: string[]);
    resetOrganization(): void;
    get organizationInput(): string[] | undefined;
    private _ou?;
    get ou(): string[];
    set ou(value: string[]);
    resetOu(): void;
    get ouInput(): string[] | undefined;
    private _policyIdentifiers?;
    get policyIdentifiers(): string[];
    set policyIdentifiers(value: string[]);
    resetPolicyIdentifiers(): void;
    get policyIdentifiersInput(): string[] | undefined;
    private _postalCode?;
    get postalCode(): string[];
    set postalCode(value: string[]);
    resetPostalCode(): void;
    get postalCodeInput(): string[] | undefined;
    private _province?;
    get province(): string[];
    set province(value: string[]);
    resetProvince(): void;
    get provinceInput(): string[] | undefined;
    private _requireCn?;
    get requireCn(): boolean | cdktf.IResolvable;
    set requireCn(value: boolean | cdktf.IResolvable);
    resetRequireCn(): void;
    get requireCnInput(): boolean | cdktf.IResolvable | undefined;
    private _serverFlag?;
    get serverFlag(): boolean | cdktf.IResolvable;
    set serverFlag(value: boolean | cdktf.IResolvable);
    resetServerFlag(): void;
    get serverFlagInput(): boolean | cdktf.IResolvable | undefined;
    private _streetAddress?;
    get streetAddress(): string[];
    set streetAddress(value: string[]);
    resetStreetAddress(): void;
    get streetAddressInput(): string[] | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _useCsrCommonName?;
    get useCsrCommonName(): boolean | cdktf.IResolvable;
    set useCsrCommonName(value: boolean | cdktf.IResolvable);
    resetUseCsrCommonName(): void;
    get useCsrCommonNameInput(): boolean | cdktf.IResolvable | undefined;
    private _useCsrSans?;
    get useCsrSans(): boolean | cdktf.IResolvable;
    set useCsrSans(value: boolean | cdktf.IResolvable);
    resetUseCsrSans(): void;
    get useCsrSansInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-role.d.ts.map