import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendIntermediateSetSignedConfig extends cdktf.TerraformMetaArguments {
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_set_signed#backend PkiSecretBackendIntermediateSetSigned#backend}
    */
    readonly backend: string;
    /**
    * The certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_set_signed#certificate PkiSecretBackendIntermediateSetSigned#certificate}
    */
    readonly certificate: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_set_signed vault_pki_secret_backend_intermediate_set_signed}
*/
export declare class PkiSecretBackendIntermediateSetSigned extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_intermediate_set_signed";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_set_signed vault_pki_secret_backend_intermediate_set_signed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendIntermediateSetSignedConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendIntermediateSetSignedConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-intermediate-set-signed.d.ts.map