import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendIntermediateCertRequestConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of alternative names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#alt_names PkiSecretBackendIntermediateCertRequest#alt_names}
    */
    readonly altNames?: string[];
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#backend PkiSecretBackendIntermediateCertRequest#backend}
    */
    readonly backend: string;
    /**
    * CN of intermediate to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#common_name PkiSecretBackendIntermediateCertRequest#common_name}
    */
    readonly commonName: string;
    /**
    * The country.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#country PkiSecretBackendIntermediateCertRequest#country}
    */
    readonly country?: string;
    /**
    * Flag to exclude CN from SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#exclude_cn_from_sans PkiSecretBackendIntermediateCertRequest#exclude_cn_from_sans}
    */
    readonly excludeCnFromSans?: boolean | cdktf.IResolvable;
    /**
    * The format of data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#format PkiSecretBackendIntermediateCertRequest#format}
    */
    readonly format?: string;
    /**
    * List of alternative IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#ip_sans PkiSecretBackendIntermediateCertRequest#ip_sans}
    */
    readonly ipSans?: string[];
    /**
    * The number of bits to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#key_bits PkiSecretBackendIntermediateCertRequest#key_bits}
    */
    readonly keyBits?: number;
    /**
    * The desired key type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#key_type PkiSecretBackendIntermediateCertRequest#key_type}
    */
    readonly keyType?: string;
    /**
    * The locality.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#locality PkiSecretBackendIntermediateCertRequest#locality}
    */
    readonly locality?: string;
    /**
    * The organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#organization PkiSecretBackendIntermediateCertRequest#organization}
    */
    readonly organization?: string;
    /**
    * List of other SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#other_sans PkiSecretBackendIntermediateCertRequest#other_sans}
    */
    readonly otherSans?: string[];
    /**
    * The organization unit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#ou PkiSecretBackendIntermediateCertRequest#ou}
    */
    readonly ou?: string;
    /**
    * The postal code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#postal_code PkiSecretBackendIntermediateCertRequest#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The private key format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#private_key_format PkiSecretBackendIntermediateCertRequest#private_key_format}
    */
    readonly privateKeyFormat?: string;
    /**
    * The province.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#province PkiSecretBackendIntermediateCertRequest#province}
    */
    readonly province?: string;
    /**
    * The street address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#street_address PkiSecretBackendIntermediateCertRequest#street_address}
    */
    readonly streetAddress?: string;
    /**
    * Type of intermediate to create. Must be either "exported" or "internal".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#type PkiSecretBackendIntermediateCertRequest#type}
    */
    readonly type: string;
    /**
    * List of alternative URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request#uri_sans PkiSecretBackendIntermediateCertRequest#uri_sans}
    */
    readonly uriSans?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request vault_pki_secret_backend_intermediate_cert_request}
*/
export declare class PkiSecretBackendIntermediateCertRequest extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_intermediate_cert_request";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_intermediate_cert_request vault_pki_secret_backend_intermediate_cert_request} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendIntermediateCertRequestConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendIntermediateCertRequestConfig);
    private _altNames?;
    get altNames(): string[];
    set altNames(value: string[]);
    resetAltNames(): void;
    get altNamesInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    get csr(): string;
    private _excludeCnFromSans?;
    get excludeCnFromSans(): boolean | cdktf.IResolvable;
    set excludeCnFromSans(value: boolean | cdktf.IResolvable);
    resetExcludeCnFromSans(): void;
    get excludeCnFromSansInput(): boolean | cdktf.IResolvable | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    get id(): string;
    private _ipSans?;
    get ipSans(): string[];
    set ipSans(value: string[]);
    resetIpSans(): void;
    get ipSansInput(): string[] | undefined;
    private _keyBits?;
    get keyBits(): number;
    set keyBits(value: number);
    resetKeyBits(): void;
    get keyBitsInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _otherSans?;
    get otherSans(): string[];
    set otherSans(value: string[]);
    resetOtherSans(): void;
    get otherSansInput(): string[] | undefined;
    private _ou?;
    get ou(): string;
    set ou(value: string);
    resetOu(): void;
    get ouInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    get privateKey(): string;
    private _privateKeyFormat?;
    get privateKeyFormat(): string;
    set privateKeyFormat(value: string);
    resetPrivateKeyFormat(): void;
    get privateKeyFormatInput(): string | undefined;
    get privateKeyType(): string;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string[];
    set uriSans(value: string[]);
    resetUriSans(): void;
    get uriSansInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-intermediate-cert-request.d.ts.map