import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendCrlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#backend PkiSecretBackendCrlConfig#backend}
    */
    readonly backend: string;
    /**
    * Disables or enables CRL building
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#disable PkiSecretBackendCrlConfig#disable}
    */
    readonly disable?: boolean | cdktf.IResolvable;
    /**
    * Specifies the time until expiration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config#expiry PkiSecretBackendCrlConfig#expiry}
    */
    readonly expiry?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config vault_pki_secret_backend_crl_config}
*/
export declare class PkiSecretBackendCrlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_crl_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_crl_config vault_pki_secret_backend_crl_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendCrlConfigConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendCrlConfigConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _disable?;
    get disable(): boolean | cdktf.IResolvable;
    set disable(value: boolean | cdktf.IResolvable);
    resetDisable(): void;
    get disableInput(): boolean | cdktf.IResolvable | undefined;
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    resetExpiry(): void;
    get expiryInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-crl-config.d.ts.map