import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendConfigCaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#backend PkiSecretBackendConfigCa#backend}
    */
    readonly backend: string;
    /**
    * The key and certificate PEM bundle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca#pem_bundle PkiSecretBackendConfigCa#pem_bundle}
    */
    readonly pemBundle: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca vault_pki_secret_backend_config_ca}
*/
export declare class PkiSecretBackendConfigCa extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_config_ca";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_config_ca vault_pki_secret_backend_config_ca} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendConfigCaConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendConfigCaConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    get pemBundleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pki-secret-backend-config-ca.d.ts.map