"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PkiSecretBackendCert = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert vault_pki_secret_backend_cert}
*/
class PkiSecretBackendCert extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_cert vault_pki_secret_backend_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendCertConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_pki_secret_backend_cert',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._altNames = config.altNames;
        this._autoRenew = config.autoRenew;
        this._backend = config.backend;
        this._commonName = config.commonName;
        this._excludeCnFromSans = config.excludeCnFromSans;
        this._format = config.format;
        this._ipSans = config.ipSans;
        this._minSecondsRemaining = config.minSecondsRemaining;
        this._name = config.name;
        this._otherSans = config.otherSans;
        this._privateKeyFormat = config.privateKeyFormat;
        this._revoke = config.revoke;
        this._ttl = config.ttl;
        this._uriSans = config.uriSans;
    }
    get altNames() {
        return this.getListAttribute('alt_names');
    }
    set altNames(value) {
        this._altNames = value;
    }
    resetAltNames() {
        this._altNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get altNamesInput() {
        return this._altNames;
    }
    get autoRenew() {
        return this.getBooleanAttribute('auto_renew');
    }
    set autoRenew(value) {
        this._autoRenew = value;
    }
    resetAutoRenew() {
        this._autoRenew = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoRenewInput() {
        return this._autoRenew;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    // ca_chain - computed: true, optional: false, required: false
    get caChain() {
        return this.getStringAttribute('ca_chain');
    }
    // certificate - computed: true, optional: false, required: false
    get certificate() {
        return this.getStringAttribute('certificate');
    }
    get commonName() {
        return this.getStringAttribute('common_name');
    }
    set commonName(value) {
        this._commonName = value;
    }
    // Temporarily expose input value. Use with caution.
    get commonNameInput() {
        return this._commonName;
    }
    get excludeCnFromSans() {
        return this.getBooleanAttribute('exclude_cn_from_sans');
    }
    set excludeCnFromSans(value) {
        this._excludeCnFromSans = value;
    }
    resetExcludeCnFromSans() {
        this._excludeCnFromSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get excludeCnFromSansInput() {
        return this._excludeCnFromSans;
    }
    // expiration - computed: true, optional: false, required: false
    get expiration() {
        return this.getNumberAttribute('expiration');
    }
    get format() {
        return this.getStringAttribute('format');
    }
    set format(value) {
        this._format = value;
    }
    resetFormat() {
        this._format = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get formatInput() {
        return this._format;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ipSans() {
        return this.getListAttribute('ip_sans');
    }
    set ipSans(value) {
        this._ipSans = value;
    }
    resetIpSans() {
        this._ipSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipSansInput() {
        return this._ipSans;
    }
    // issuing_ca - computed: true, optional: false, required: false
    get issuingCa() {
        return this.getStringAttribute('issuing_ca');
    }
    get minSecondsRemaining() {
        return this.getNumberAttribute('min_seconds_remaining');
    }
    set minSecondsRemaining(value) {
        this._minSecondsRemaining = value;
    }
    resetMinSecondsRemaining() {
        this._minSecondsRemaining = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minSecondsRemainingInput() {
        return this._minSecondsRemaining;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get otherSans() {
        return this.getListAttribute('other_sans');
    }
    set otherSans(value) {
        this._otherSans = value;
    }
    resetOtherSans() {
        this._otherSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get otherSansInput() {
        return this._otherSans;
    }
    // private_key - computed: true, optional: false, required: false
    get privateKey() {
        return this.getStringAttribute('private_key');
    }
    get privateKeyFormat() {
        return this.getStringAttribute('private_key_format');
    }
    set privateKeyFormat(value) {
        this._privateKeyFormat = value;
    }
    resetPrivateKeyFormat() {
        this._privateKeyFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyFormatInput() {
        return this._privateKeyFormat;
    }
    // private_key_type - computed: true, optional: false, required: false
    get privateKeyType() {
        return this.getStringAttribute('private_key_type');
    }
    get revoke() {
        return this.getBooleanAttribute('revoke');
    }
    set revoke(value) {
        this._revoke = value;
    }
    resetRevoke() {
        this._revoke = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get revokeInput() {
        return this._revoke;
    }
    // serial_number - computed: true, optional: false, required: false
    get serialNumber() {
        return this.getStringAttribute('serial_number');
    }
    get ttl() {
        return this.getStringAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    resetTtl() {
        this._ttl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
    get uriSans() {
        return this.getListAttribute('uri_sans');
    }
    set uriSans(value) {
        this._uriSans = value;
    }
    resetUriSans() {
        this._uriSans = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uriSansInput() {
        return this._uriSans;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alt_names: cdktf.listMapper(cdktf.stringToTerraform)(this._altNames),
            auto_renew: cdktf.booleanToTerraform(this._autoRenew),
            backend: cdktf.stringToTerraform(this._backend),
            common_name: cdktf.stringToTerraform(this._commonName),
            exclude_cn_from_sans: cdktf.booleanToTerraform(this._excludeCnFromSans),
            format: cdktf.stringToTerraform(this._format),
            ip_sans: cdktf.listMapper(cdktf.stringToTerraform)(this._ipSans),
            min_seconds_remaining: cdktf.numberToTerraform(this._minSecondsRemaining),
            name: cdktf.stringToTerraform(this._name),
            other_sans: cdktf.listMapper(cdktf.stringToTerraform)(this._otherSans),
            private_key_format: cdktf.stringToTerraform(this._privateKeyFormat),
            revoke: cdktf.booleanToTerraform(this._revoke),
            ttl: cdktf.stringToTerraform(this._ttl),
            uri_sans: cdktf.listMapper(cdktf.stringToTerraform)(this._uriSans),
        };
    }
}
exports.PkiSecretBackendCert = PkiSecretBackendCert;
_a = JSII_RTTI_SYMBOL_1;
PkiSecretBackendCert[_a] = { fqn: "hashicorp_vault.PkiSecretBackendCert", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
PkiSecretBackendCert.tfResourceType = "vault_pki_secret_backend_cert";
//# sourceMappingURL=data:application/json;base64,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