import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PasswordPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the password policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/password_policy#name PasswordPolicy#name}
    */
    readonly name: string;
    /**
    * The password policy document
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/password_policy#policy PasswordPolicy#policy}
    */
    readonly policy: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/password_policy vault_password_policy}
*/
export declare class PasswordPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_password_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/password_policy vault_password_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PasswordPolicyConfig
    */
    constructor(scope: Construct, id: string, config: PasswordPolicyConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=password-policy.d.ts.map