import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OktaAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Okta url. Examples: oktapreview.com, okta.com (default)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#base_url OktaAuthBackend#base_url}
    */
    readonly baseUrl?: string;
    /**
    * When true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#bypass_okta_mfa OktaAuthBackend#bypass_okta_mfa}
    */
    readonly bypassOktaMfa?: boolean | cdktf.IResolvable;
    /**
    * The description of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#description OktaAuthBackend#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#group OktaAuthBackend#group}
    */
    readonly group?: OktaAuthBackendGroup[] | cdktf.IResolvable;
    /**
    * Maximum duration after which authentication will be expired
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#max_ttl OktaAuthBackend#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * The Okta organization. This will be the first part of the url https://XXX.okta.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#organization OktaAuthBackend#organization}
    */
    readonly organization: string;
    /**
    * path to mount the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#path OktaAuthBackend#path}
    */
    readonly path?: string;
    /**
    * The Okta API token. This is required to query Okta for user group membership. If this is not supplied only locally configured groups will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#token OktaAuthBackend#token}
    */
    readonly token?: string;
    /**
    * Duration after which authentication will be expired
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#ttl OktaAuthBackend#ttl}
    */
    readonly ttl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#user OktaAuthBackend#user}
    */
    readonly user?: OktaAuthBackendUser[] | cdktf.IResolvable;
}
export interface OktaAuthBackendGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#group_name OktaAuthBackend#group_name}
    */
    readonly groupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#policies OktaAuthBackend#policies}
    */
    readonly policies?: string[];
}
export declare function oktaAuthBackendGroupToTerraform(struct?: OktaAuthBackendGroup | cdktf.IResolvable): any;
export interface OktaAuthBackendUser {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#groups OktaAuthBackend#groups}
    */
    readonly groups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#policies OktaAuthBackend#policies}
    */
    readonly policies?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#username OktaAuthBackend#username}
    */
    readonly username?: string;
}
export declare function oktaAuthBackendUserToTerraform(struct?: OktaAuthBackendUser | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend vault_okta_auth_backend}
*/
export declare class OktaAuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_okta_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend vault_okta_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OktaAuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: OktaAuthBackendConfig);
    get accessor(): string;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _bypassOktaMfa?;
    get bypassOktaMfa(): boolean | cdktf.IResolvable;
    set bypassOktaMfa(value: boolean | cdktf.IResolvable);
    resetBypassOktaMfa(): void;
    get bypassOktaMfaInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _group?;
    get group(): OktaAuthBackendGroup[] | cdktf.IResolvable;
    set group(value: OktaAuthBackendGroup[] | cdktf.IResolvable);
    resetGroup(): void;
    get groupInput(): cdktf.IResolvable | OktaAuthBackendGroup[] | undefined;
    get id(): string;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _user?;
    get user(): OktaAuthBackendUser[] | cdktf.IResolvable;
    set user(value: OktaAuthBackendUser[] | cdktf.IResolvable);
    resetUser(): void;
    get userInput(): cdktf.IResolvable | OktaAuthBackendUser[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=okta-auth-backend.d.ts.map