import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OktaAuthBackendGroupAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the Okta group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend_group#group_name OktaAuthBackendGroupA#group_name}
    */
    readonly groupName: string;
    /**
    * Path to the Okta auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend_group#path OktaAuthBackendGroupA#path}
    */
    readonly path: string;
    /**
    * Policies to associate with this group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend_group#policies OktaAuthBackendGroupA#policies}
    */
    readonly policies?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend_group vault_okta_auth_backend_group}
*/
export declare class OktaAuthBackendGroupA extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_okta_auth_backend_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend_group vault_okta_auth_backend_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OktaAuthBackendGroupAConfig
    */
    constructor(scope: Construct, id: string, config: OktaAuthBackendGroupAConfig);
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    get groupNameInput(): string | undefined;
    get id(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=okta-auth-backend-group.d.ts.map