import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#audit_non_hmac_request_keys Mount#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#audit_non_hmac_response_keys Mount#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Default lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#default_lease_ttl_seconds Mount#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#description Mount#description}
    */
    readonly description?: string;
    /**
    * Enable the secrets engine to access Vault's external entropy source
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#external_entropy_access Mount#external_entropy_access}
    */
    readonly externalEntropyAccess?: boolean | cdktf.IResolvable;
    /**
    * Local mount flag that can be explicitly set to true to enforce local mount in HA environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#local Mount#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum possible lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#max_lease_ttl_seconds Mount#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Specifies mount type specific options that are passed to the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#options Mount#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Where the secret backend will be mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#path Mount#path}
    */
    readonly path: string;
    /**
    * Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#seal_wrap Mount#seal_wrap}
    */
    readonly sealWrap?: boolean | cdktf.IResolvable;
    /**
    * Type of the backend, such as 'aws'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mount#type Mount#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/mount vault_mount}
*/
export declare class Mount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_mount";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/mount vault_mount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MountConfig
    */
    constructor(scope: Construct, id: string, config: MountConfig);
    get accessor(): string;
    private _auditNonHmacRequestKeys?;
    get auditNonHmacRequestKeys(): string[];
    set auditNonHmacRequestKeys(value: string[]);
    resetAuditNonHmacRequestKeys(): void;
    get auditNonHmacRequestKeysInput(): string[] | undefined;
    private _auditNonHmacResponseKeys?;
    get auditNonHmacResponseKeys(): string[];
    set auditNonHmacResponseKeys(value: string[]);
    resetAuditNonHmacResponseKeys(): void;
    get auditNonHmacResponseKeysInput(): string[] | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _externalEntropyAccess?;
    get externalEntropyAccess(): boolean | cdktf.IResolvable;
    set externalEntropyAccess(value: boolean | cdktf.IResolvable);
    resetExternalEntropyAccess(): void;
    get externalEntropyAccessInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _sealWrap?;
    get sealWrap(): boolean | cdktf.IResolvable;
    set sealWrap(value: boolean | cdktf.IResolvable);
    resetSealWrap(): void;
    get sealWrapInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=mount.d.ts.map