import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaPingidConfig extends cdktf.TerraformMetaArguments {
    /**
    * The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid#mount_accessor MfaPingid#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the MFA method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid#name MfaPingid#name}
    */
    readonly name: string;
    /**
    * A base64-encoded third-party settings file retrieved from PingID's configuration page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid#settings_file_base64 MfaPingid#settings_file_base64}
    */
    readonly settingsFileBase64: string;
    /**
    * A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid#username_format MfaPingid#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid vault_mfa_pingid}
*/
export declare class MfaPingid extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_mfa_pingid";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/mfa_pingid vault_mfa_pingid} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaPingidConfig
    */
    constructor(scope: Construct, id: string, config: MfaPingidConfig);
    get adminUrl(): string;
    get authenticatorUrl(): string;
    get id(): string;
    get idpUrl(): string;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get namespaceId(): string;
    get orgAlias(): string;
    private _settingsFileBase64?;
    get settingsFileBase64(): string;
    set settingsFileBase64(value: string);
    get settingsFileBase64Input(): string | undefined;
    get type(): string;
    get useSignature(): cdktf.IResolvable;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=mfa-pingid.d.ts.map