import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MfaOktaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Okta API key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#api_token MfaOkta#api_token}
    */
    readonly apiToken: string;
    /**
    * If set, will be used as the base domain for API requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#base_url MfaOkta#base_url}
    */
    readonly baseUrl?: string;
    /**
    * The mount to tie this method to for use in automatic mappings. The mapping will use the Name field of Aliases associated with this mount as the username in the mapping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#mount_accessor MfaOkta#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the MFA method.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#name MfaOkta#name}
    */
    readonly name: string;
    /**
    * Name of the organization to be used in the Okta API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#org_name MfaOkta#org_name}
    */
    readonly orgName: string;
    /**
    * If set to true, the username will only match the primary email for the account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#primary_email MfaOkta#primary_email}
    */
    readonly primaryEmail?: boolean | cdktf.IResolvable;
    /**
    * A format string for mapping Identity names to MFA method names. Values to substitute should be placed in `{{}}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta#username_format MfaOkta#username_format}
    */
    readonly usernameFormat?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta vault_mfa_okta}
*/
export declare class MfaOkta extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_mfa_okta";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/mfa_okta vault_mfa_okta} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MfaOktaConfig
    */
    constructor(scope: Construct, id: string, config: MfaOktaConfig);
    private _apiToken?;
    get apiToken(): string;
    set apiToken(value: string);
    get apiTokenInput(): string | undefined;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    get id(): string;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgName?;
    get orgName(): string;
    set orgName(value: string);
    get orgNameInput(): string | undefined;
    private _primaryEmail?;
    get primaryEmail(): boolean | cdktf.IResolvable;
    set primaryEmail(value: boolean | cdktf.IResolvable);
    resetPrimaryEmail(): void;
    get primaryEmailInput(): boolean | cdktf.IResolvable | undefined;
    private _usernameFormat?;
    get usernameFormat(): string;
    set usernameFormat(value: string);
    resetUsernameFormat(): void;
    get usernameFormatInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=mfa-okta.d.ts.map