"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesAuthBackendConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config}
*/
class KubernetesAuthBackendConfig extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesAuthBackendConfigConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kubernetes_auth_backend_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._backend = config.backend;
        this._disableIssValidation = config.disableIssValidation;
        this._disableLocalCaJwt = config.disableLocalCaJwt;
        this._issuer = config.issuer;
        this._kubernetesCaCert = config.kubernetesCaCert;
        this._kubernetesHost = config.kubernetesHost;
        this._pemKeys = config.pemKeys;
        this._tokenReviewerJwt = config.tokenReviewerJwt;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get disableIssValidation() {
        return this.getBooleanAttribute('disable_iss_validation');
    }
    set disableIssValidation(value) {
        this._disableIssValidation = value;
    }
    resetDisableIssValidation() {
        this._disableIssValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableIssValidationInput() {
        return this._disableIssValidation;
    }
    get disableLocalCaJwt() {
        return this.getBooleanAttribute('disable_local_ca_jwt');
    }
    set disableLocalCaJwt(value) {
        this._disableLocalCaJwt = value;
    }
    resetDisableLocalCaJwt() {
        this._disableLocalCaJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableLocalCaJwtInput() {
        return this._disableLocalCaJwt;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get kubernetesCaCert() {
        return this.getStringAttribute('kubernetes_ca_cert');
    }
    set kubernetesCaCert(value) {
        this._kubernetesCaCert = value;
    }
    resetKubernetesCaCert() {
        this._kubernetesCaCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesCaCertInput() {
        return this._kubernetesCaCert;
    }
    get kubernetesHost() {
        return this.getStringAttribute('kubernetes_host');
    }
    set kubernetesHost(value) {
        this._kubernetesHost = value;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesHostInput() {
        return this._kubernetesHost;
    }
    get pemKeys() {
        return this.getListAttribute('pem_keys');
    }
    set pemKeys(value) {
        this._pemKeys = value;
    }
    resetPemKeys() {
        this._pemKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pemKeysInput() {
        return this._pemKeys;
    }
    get tokenReviewerJwt() {
        return this.getStringAttribute('token_reviewer_jwt');
    }
    set tokenReviewerJwt(value) {
        this._tokenReviewerJwt = value;
    }
    resetTokenReviewerJwt() {
        this._tokenReviewerJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenReviewerJwtInput() {
        return this._tokenReviewerJwt;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            disable_iss_validation: cdktf.booleanToTerraform(this._disableIssValidation),
            disable_local_ca_jwt: cdktf.booleanToTerraform(this._disableLocalCaJwt),
            issuer: cdktf.stringToTerraform(this._issuer),
            kubernetes_ca_cert: cdktf.stringToTerraform(this._kubernetesCaCert),
            kubernetes_host: cdktf.stringToTerraform(this._kubernetesHost),
            pem_keys: cdktf.listMapper(cdktf.stringToTerraform)(this._pemKeys),
            token_reviewer_jwt: cdktf.stringToTerraform(this._tokenReviewerJwt),
        };
    }
}
exports.KubernetesAuthBackendConfig = KubernetesAuthBackendConfig;
_a = JSII_RTTI_SYMBOL_1;
KubernetesAuthBackendConfig[_a] = { fqn: "hashicorp_vault.KubernetesAuthBackendConfig", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
KubernetesAuthBackendConfig.tfResourceType = "vault_kubernetes_auth_backend_config";
//# sourceMappingURL=data:application/json;base64,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