import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesAuthBackendConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the kubernetes backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#backend KubernetesAuthBackendConfig#backend}
    */
    readonly backend?: string;
    /**
    * Optional disable JWT issuer validation. Allows to skip ISS validation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#disable_iss_validation KubernetesAuthBackendConfig#disable_iss_validation}
    */
    readonly disableIssValidation?: boolean | cdktf.IResolvable;
    /**
    * Optional disable defaulting to the local CA cert and service account JWT when running in a Kubernetes pod.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#disable_local_ca_jwt KubernetesAuthBackendConfig#disable_local_ca_jwt}
    */
    readonly disableLocalCaJwt?: boolean | cdktf.IResolvable;
    /**
    * Optional JWT issuer. If no issuer is specified, kubernetes.io/serviceaccount will be used as the default issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#issuer KubernetesAuthBackendConfig#issuer}
    */
    readonly issuer?: string;
    /**
    * PEM encoded CA cert for use by the TLS client used to talk with the Kubernetes API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#kubernetes_ca_cert KubernetesAuthBackendConfig#kubernetes_ca_cert}
    */
    readonly kubernetesCaCert?: string;
    /**
    * Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#kubernetes_host KubernetesAuthBackendConfig#kubernetes_host}
    */
    readonly kubernetesHost: string;
    /**
    * Optional list of PEM-formatted public keys or certificates used to verify the signatures of Kubernetes service account JWTs. If a certificate is given, its public key will be extracted. Not every installation of Kubernetes exposes these keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#pem_keys KubernetesAuthBackendConfig#pem_keys}
    */
    readonly pemKeys?: string[];
    /**
    * A service account JWT used to access the TokenReview API to validate other JWTs during login. If not set the JWT used for login will be used to access the API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config#token_reviewer_jwt KubernetesAuthBackendConfig#token_reviewer_jwt}
    */
    readonly tokenReviewerJwt?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config}
*/
export declare class KubernetesAuthBackendConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kubernetes_auth_backend_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesAuthBackendConfigConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesAuthBackendConfigConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _disableIssValidation?;
    get disableIssValidation(): boolean | cdktf.IResolvable;
    set disableIssValidation(value: boolean | cdktf.IResolvable);
    resetDisableIssValidation(): void;
    get disableIssValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableLocalCaJwt?;
    get disableLocalCaJwt(): boolean | cdktf.IResolvable;
    set disableLocalCaJwt(value: boolean | cdktf.IResolvable);
    resetDisableLocalCaJwt(): void;
    get disableLocalCaJwtInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _kubernetesCaCert?;
    get kubernetesCaCert(): string;
    set kubernetesCaCert(value: string);
    resetKubernetesCaCert(): void;
    get kubernetesCaCertInput(): string | undefined;
    private _kubernetesHost?;
    get kubernetesHost(): string;
    set kubernetesHost(value: string);
    get kubernetesHostInput(): string | undefined;
    private _pemKeys?;
    get pemKeys(): string[];
    set pemKeys(value: string[]);
    resetPemKeys(): void;
    get pemKeysInput(): string[] | undefined;
    private _tokenReviewerJwt?;
    get tokenReviewerJwt(): string;
    set tokenReviewerJwt(value: string);
    resetTokenReviewerJwt(): void;
    get tokenReviewerJwtInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=kubernetes-auth-backend-config.d.ts.map