"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmipSecretRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role}
*/
class KmipSecretRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kmip_secret_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._operationActivate = config.operationActivate;
        this._operationAddAttribute = config.operationAddAttribute;
        this._operationAll = config.operationAll;
        this._operationCreate = config.operationCreate;
        this._operationDestroy = config.operationDestroy;
        this._operationDiscoverVersions = config.operationDiscoverVersions;
        this._operationGet = config.operationGet;
        this._operationGetAttributeList = config.operationGetAttributeList;
        this._operationGetAttributes = config.operationGetAttributes;
        this._operationLocate = config.operationLocate;
        this._operationNone = config.operationNone;
        this._operationRegister = config.operationRegister;
        this._operationRekey = config.operationRekey;
        this._operationRevoke = config.operationRevoke;
        this._path = config.path;
        this._role = config.role;
        this._scope = config.scope;
        this._tlsClientKeyBits = config.tlsClientKeyBits;
        this._tlsClientKeyType = config.tlsClientKeyType;
        this._tlsClientTtl = config.tlsClientTtl;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get operationActivate() {
        return this.getBooleanAttribute('operation_activate');
    }
    set operationActivate(value) {
        this._operationActivate = value;
    }
    resetOperationActivate() {
        this._operationActivate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationActivateInput() {
        return this._operationActivate;
    }
    get operationAddAttribute() {
        return this.getBooleanAttribute('operation_add_attribute');
    }
    set operationAddAttribute(value) {
        this._operationAddAttribute = value;
    }
    resetOperationAddAttribute() {
        this._operationAddAttribute = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationAddAttributeInput() {
        return this._operationAddAttribute;
    }
    get operationAll() {
        return this.getBooleanAttribute('operation_all');
    }
    set operationAll(value) {
        this._operationAll = value;
    }
    resetOperationAll() {
        this._operationAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationAllInput() {
        return this._operationAll;
    }
    get operationCreate() {
        return this.getBooleanAttribute('operation_create');
    }
    set operationCreate(value) {
        this._operationCreate = value;
    }
    resetOperationCreate() {
        this._operationCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationCreateInput() {
        return this._operationCreate;
    }
    get operationDestroy() {
        return this.getBooleanAttribute('operation_destroy');
    }
    set operationDestroy(value) {
        this._operationDestroy = value;
    }
    resetOperationDestroy() {
        this._operationDestroy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationDestroyInput() {
        return this._operationDestroy;
    }
    get operationDiscoverVersions() {
        return this.getBooleanAttribute('operation_discover_versions');
    }
    set operationDiscoverVersions(value) {
        this._operationDiscoverVersions = value;
    }
    resetOperationDiscoverVersions() {
        this._operationDiscoverVersions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationDiscoverVersionsInput() {
        return this._operationDiscoverVersions;
    }
    get operationGet() {
        return this.getBooleanAttribute('operation_get');
    }
    set operationGet(value) {
        this._operationGet = value;
    }
    resetOperationGet() {
        this._operationGet = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetInput() {
        return this._operationGet;
    }
    get operationGetAttributeList() {
        return this.getBooleanAttribute('operation_get_attribute_list');
    }
    set operationGetAttributeList(value) {
        this._operationGetAttributeList = value;
    }
    resetOperationGetAttributeList() {
        this._operationGetAttributeList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetAttributeListInput() {
        return this._operationGetAttributeList;
    }
    get operationGetAttributes() {
        return this.getBooleanAttribute('operation_get_attributes');
    }
    set operationGetAttributes(value) {
        this._operationGetAttributes = value;
    }
    resetOperationGetAttributes() {
        this._operationGetAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationGetAttributesInput() {
        return this._operationGetAttributes;
    }
    get operationLocate() {
        return this.getBooleanAttribute('operation_locate');
    }
    set operationLocate(value) {
        this._operationLocate = value;
    }
    resetOperationLocate() {
        this._operationLocate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationLocateInput() {
        return this._operationLocate;
    }
    get operationNone() {
        return this.getBooleanAttribute('operation_none');
    }
    set operationNone(value) {
        this._operationNone = value;
    }
    resetOperationNone() {
        this._operationNone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationNoneInput() {
        return this._operationNone;
    }
    get operationRegister() {
        return this.getBooleanAttribute('operation_register');
    }
    set operationRegister(value) {
        this._operationRegister = value;
    }
    resetOperationRegister() {
        this._operationRegister = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRegisterInput() {
        return this._operationRegister;
    }
    get operationRekey() {
        return this.getBooleanAttribute('operation_rekey');
    }
    set operationRekey(value) {
        this._operationRekey = value;
    }
    resetOperationRekey() {
        this._operationRekey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRekeyInput() {
        return this._operationRekey;
    }
    get operationRevoke() {
        return this.getBooleanAttribute('operation_revoke');
    }
    set operationRevoke(value) {
        this._operationRevoke = value;
    }
    resetOperationRevoke() {
        this._operationRevoke = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationRevokeInput() {
        return this._operationRevoke;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get scope() {
        return this.getStringAttribute('scope');
    }
    set scope(value) {
        this._scope = value;
    }
    // Temporarily expose input value. Use with caution.
    get scopeInput() {
        return this._scope;
    }
    get tlsClientKeyBits() {
        return this.getNumberAttribute('tls_client_key_bits');
    }
    set tlsClientKeyBits(value) {
        this._tlsClientKeyBits = value;
    }
    resetTlsClientKeyBits() {
        this._tlsClientKeyBits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientKeyBitsInput() {
        return this._tlsClientKeyBits;
    }
    get tlsClientKeyType() {
        return this.getStringAttribute('tls_client_key_type');
    }
    set tlsClientKeyType(value) {
        this._tlsClientKeyType = value;
    }
    resetTlsClientKeyType() {
        this._tlsClientKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientKeyTypeInput() {
        return this._tlsClientKeyType;
    }
    get tlsClientTtl() {
        return this.getNumberAttribute('tls_client_ttl');
    }
    set tlsClientTtl(value) {
        this._tlsClientTtl = value;
    }
    resetTlsClientTtl() {
        this._tlsClientTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsClientTtlInput() {
        return this._tlsClientTtl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            operation_activate: cdktf.booleanToTerraform(this._operationActivate),
            operation_add_attribute: cdktf.booleanToTerraform(this._operationAddAttribute),
            operation_all: cdktf.booleanToTerraform(this._operationAll),
            operation_create: cdktf.booleanToTerraform(this._operationCreate),
            operation_destroy: cdktf.booleanToTerraform(this._operationDestroy),
            operation_discover_versions: cdktf.booleanToTerraform(this._operationDiscoverVersions),
            operation_get: cdktf.booleanToTerraform(this._operationGet),
            operation_get_attribute_list: cdktf.booleanToTerraform(this._operationGetAttributeList),
            operation_get_attributes: cdktf.booleanToTerraform(this._operationGetAttributes),
            operation_locate: cdktf.booleanToTerraform(this._operationLocate),
            operation_none: cdktf.booleanToTerraform(this._operationNone),
            operation_register: cdktf.booleanToTerraform(this._operationRegister),
            operation_rekey: cdktf.booleanToTerraform(this._operationRekey),
            operation_revoke: cdktf.booleanToTerraform(this._operationRevoke),
            path: cdktf.stringToTerraform(this._path),
            role: cdktf.stringToTerraform(this._role),
            scope: cdktf.stringToTerraform(this._scope),
            tls_client_key_bits: cdktf.numberToTerraform(this._tlsClientKeyBits),
            tls_client_key_type: cdktf.stringToTerraform(this._tlsClientKeyType),
            tls_client_ttl: cdktf.numberToTerraform(this._tlsClientTtl),
        };
    }
}
exports.KmipSecretRole = KmipSecretRole;
_a = JSII_RTTI_SYMBOL_1;
KmipSecretRole[_a] = { fqn: "hashicorp_vault.KmipSecretRole", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
KmipSecretRole.tfResourceType = "vault_kmip_secret_role";
//# sourceMappingURL=data:application/json;base64,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