"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KmipSecretBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend vault_kmip_secret_backend}
*/
class KmipSecretBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_backend vault_kmip_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretBackendConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_kmip_secret_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultTlsClientKeyBits = config.defaultTlsClientKeyBits;
        this._defaultTlsClientKeyType = config.defaultTlsClientKeyType;
        this._defaultTlsClientTtl = config.defaultTlsClientTtl;
        this._description = config.description;
        this._listenAddrs = config.listenAddrs;
        this._path = config.path;
        this._serverHostnames = config.serverHostnames;
        this._serverIps = config.serverIps;
        this._tlsCaKeyBits = config.tlsCaKeyBits;
        this._tlsCaKeyType = config.tlsCaKeyType;
        this._tlsMinVersion = config.tlsMinVersion;
    }
    get defaultTlsClientKeyBits() {
        return this.getNumberAttribute('default_tls_client_key_bits');
    }
    set defaultTlsClientKeyBits(value) {
        this._defaultTlsClientKeyBits = value;
    }
    resetDefaultTlsClientKeyBits() {
        this._defaultTlsClientKeyBits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTlsClientKeyBitsInput() {
        return this._defaultTlsClientKeyBits;
    }
    get defaultTlsClientKeyType() {
        return this.getStringAttribute('default_tls_client_key_type');
    }
    set defaultTlsClientKeyType(value) {
        this._defaultTlsClientKeyType = value;
    }
    resetDefaultTlsClientKeyType() {
        this._defaultTlsClientKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTlsClientKeyTypeInput() {
        return this._defaultTlsClientKeyType;
    }
    get defaultTlsClientTtl() {
        return this.getNumberAttribute('default_tls_client_ttl');
    }
    set defaultTlsClientTtl(value) {
        this._defaultTlsClientTtl = value;
    }
    resetDefaultTlsClientTtl() {
        this._defaultTlsClientTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultTlsClientTtlInput() {
        return this._defaultTlsClientTtl;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get listenAddrs() {
        return cdktf.Fn.tolist(this.getListAttribute('listen_addrs'));
    }
    set listenAddrs(value) {
        this._listenAddrs = value;
    }
    resetListenAddrs() {
        this._listenAddrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get listenAddrsInput() {
        return this._listenAddrs;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get serverHostnames() {
        return cdktf.Fn.tolist(this.getListAttribute('server_hostnames'));
    }
    set serverHostnames(value) {
        this._serverHostnames = value;
    }
    resetServerHostnames() {
        this._serverHostnames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverHostnamesInput() {
        return this._serverHostnames;
    }
    get serverIps() {
        return cdktf.Fn.tolist(this.getListAttribute('server_ips'));
    }
    set serverIps(value) {
        this._serverIps = value;
    }
    resetServerIps() {
        this._serverIps = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverIpsInput() {
        return this._serverIps;
    }
    get tlsCaKeyBits() {
        return this.getNumberAttribute('tls_ca_key_bits');
    }
    set tlsCaKeyBits(value) {
        this._tlsCaKeyBits = value;
    }
    resetTlsCaKeyBits() {
        this._tlsCaKeyBits = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsCaKeyBitsInput() {
        return this._tlsCaKeyBits;
    }
    get tlsCaKeyType() {
        return this.getStringAttribute('tls_ca_key_type');
    }
    set tlsCaKeyType(value) {
        this._tlsCaKeyType = value;
    }
    resetTlsCaKeyType() {
        this._tlsCaKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsCaKeyTypeInput() {
        return this._tlsCaKeyType;
    }
    get tlsMinVersion() {
        return this.getStringAttribute('tls_min_version');
    }
    set tlsMinVersion(value) {
        this._tlsMinVersion = value;
    }
    resetTlsMinVersion() {
        this._tlsMinVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tlsMinVersionInput() {
        return this._tlsMinVersion;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_tls_client_key_bits: cdktf.numberToTerraform(this._defaultTlsClientKeyBits),
            default_tls_client_key_type: cdktf.stringToTerraform(this._defaultTlsClientKeyType),
            default_tls_client_ttl: cdktf.numberToTerraform(this._defaultTlsClientTtl),
            description: cdktf.stringToTerraform(this._description),
            listen_addrs: cdktf.listMapper(cdktf.stringToTerraform)(this._listenAddrs),
            path: cdktf.stringToTerraform(this._path),
            server_hostnames: cdktf.listMapper(cdktf.stringToTerraform)(this._serverHostnames),
            server_ips: cdktf.listMapper(cdktf.stringToTerraform)(this._serverIps),
            tls_ca_key_bits: cdktf.numberToTerraform(this._tlsCaKeyBits),
            tls_ca_key_type: cdktf.stringToTerraform(this._tlsCaKeyType),
            tls_min_version: cdktf.stringToTerraform(this._tlsMinVersion),
        };
    }
}
exports.KmipSecretBackend = KmipSecretBackend;
_a = JSII_RTTI_SYMBOL_1;
KmipSecretBackend[_a] = { fqn: "hashicorp_vault.KmipSecretBackend", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
KmipSecretBackend.tfResourceType = "vault_kmip_secret_backend";
//# sourceMappingURL=data:application/json;base64,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