"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthBackend = exports.jwtAuthBackendTuneToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function jwtAuthBackendTuneToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_response_headers: struct.allowedResponseHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedResponseHeaders),
        audit_non_hmac_request_keys: struct.auditNonHmacRequestKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacRequestKeys),
        audit_non_hmac_response_keys: struct.auditNonHmacResponseKeys === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.auditNonHmacResponseKeys),
        default_lease_ttl: struct.defaultLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.defaultLeaseTtl),
        listing_visibility: struct.listingVisibility === undefined ? null : cdktf.stringToTerraform(struct.listingVisibility),
        max_lease_ttl: struct.maxLeaseTtl === undefined ? null : cdktf.stringToTerraform(struct.maxLeaseTtl),
        passthrough_request_headers: struct.passthroughRequestHeaders === undefined ? null : cdktf.listMapper(cdktf.stringToTerraform)(struct.passthroughRequestHeaders),
        token_type: struct.tokenType === undefined ? null : cdktf.stringToTerraform(struct.tokenType),
    };
}
exports.jwtAuthBackendTuneToTerraform = jwtAuthBackendTuneToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend}
*/
class JwtAuthBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_jwt_auth_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._boundIssuer = config.boundIssuer;
        this._defaultRole = config.defaultRole;
        this._description = config.description;
        this._jwksCaPem = config.jwksCaPem;
        this._jwksUrl = config.jwksUrl;
        this._jwtSupportedAlgs = config.jwtSupportedAlgs;
        this._jwtValidationPubkeys = config.jwtValidationPubkeys;
        this._local = config.local;
        this._namespaceInState = config.namespaceInState;
        this._oidcClientId = config.oidcClientId;
        this._oidcClientSecret = config.oidcClientSecret;
        this._oidcDiscoveryCaPem = config.oidcDiscoveryCaPem;
        this._oidcDiscoveryUrl = config.oidcDiscoveryUrl;
        this._oidcResponseMode = config.oidcResponseMode;
        this._oidcResponseTypes = config.oidcResponseTypes;
        this._path = config.path;
        this._providerConfig = config.providerConfig;
        this._tune = config.tune;
        this._type = config.type;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get boundIssuer() {
        return this.getStringAttribute('bound_issuer');
    }
    set boundIssuer(value) {
        this._boundIssuer = value;
    }
    resetBoundIssuer() {
        this._boundIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundIssuerInput() {
        return this._boundIssuer;
    }
    get defaultRole() {
        return this.getStringAttribute('default_role');
    }
    set defaultRole(value) {
        this._defaultRole = value;
    }
    resetDefaultRole() {
        this._defaultRole = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultRoleInput() {
        return this._defaultRole;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get jwksCaPem() {
        return this.getStringAttribute('jwks_ca_pem');
    }
    set jwksCaPem(value) {
        this._jwksCaPem = value;
    }
    resetJwksCaPem() {
        this._jwksCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksCaPemInput() {
        return this._jwksCaPem;
    }
    get jwksUrl() {
        return this.getStringAttribute('jwks_url');
    }
    set jwksUrl(value) {
        this._jwksUrl = value;
    }
    resetJwksUrl() {
        this._jwksUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwksUrlInput() {
        return this._jwksUrl;
    }
    get jwtSupportedAlgs() {
        return this.getListAttribute('jwt_supported_algs');
    }
    set jwtSupportedAlgs(value) {
        this._jwtSupportedAlgs = value;
    }
    resetJwtSupportedAlgs() {
        this._jwtSupportedAlgs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtSupportedAlgsInput() {
        return this._jwtSupportedAlgs;
    }
    get jwtValidationPubkeys() {
        return this.getListAttribute('jwt_validation_pubkeys');
    }
    set jwtValidationPubkeys(value) {
        this._jwtValidationPubkeys = value;
    }
    resetJwtValidationPubkeys() {
        this._jwtValidationPubkeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtValidationPubkeysInput() {
        return this._jwtValidationPubkeys;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get namespaceInState() {
        return this.getBooleanAttribute('namespace_in_state');
    }
    set namespaceInState(value) {
        this._namespaceInState = value;
    }
    resetNamespaceInState() {
        this._namespaceInState = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInStateInput() {
        return this._namespaceInState;
    }
    get oidcClientId() {
        return this.getStringAttribute('oidc_client_id');
    }
    set oidcClientId(value) {
        this._oidcClientId = value;
    }
    resetOidcClientId() {
        this._oidcClientId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientIdInput() {
        return this._oidcClientId;
    }
    get oidcClientSecret() {
        return this.getStringAttribute('oidc_client_secret');
    }
    set oidcClientSecret(value) {
        this._oidcClientSecret = value;
    }
    resetOidcClientSecret() {
        this._oidcClientSecret = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcClientSecretInput() {
        return this._oidcClientSecret;
    }
    get oidcDiscoveryCaPem() {
        return this.getStringAttribute('oidc_discovery_ca_pem');
    }
    set oidcDiscoveryCaPem(value) {
        this._oidcDiscoveryCaPem = value;
    }
    resetOidcDiscoveryCaPem() {
        this._oidcDiscoveryCaPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryCaPemInput() {
        return this._oidcDiscoveryCaPem;
    }
    get oidcDiscoveryUrl() {
        return this.getStringAttribute('oidc_discovery_url');
    }
    set oidcDiscoveryUrl(value) {
        this._oidcDiscoveryUrl = value;
    }
    resetOidcDiscoveryUrl() {
        this._oidcDiscoveryUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcDiscoveryUrlInput() {
        return this._oidcDiscoveryUrl;
    }
    get oidcResponseMode() {
        return this.getStringAttribute('oidc_response_mode');
    }
    set oidcResponseMode(value) {
        this._oidcResponseMode = value;
    }
    resetOidcResponseMode() {
        this._oidcResponseMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseModeInput() {
        return this._oidcResponseMode;
    }
    get oidcResponseTypes() {
        return this.getListAttribute('oidc_response_types');
    }
    set oidcResponseTypes(value) {
        this._oidcResponseTypes = value;
    }
    resetOidcResponseTypes() {
        this._oidcResponseTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcResponseTypesInput() {
        return this._oidcResponseTypes;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    resetPath() {
        this._path = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get providerConfig() {
        return this.getStringMapAttribute('provider_config');
    }
    set providerConfig(value) {
        this._providerConfig = value;
    }
    resetProviderConfig() {
        this._providerConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get providerConfigInput() {
        return this._providerConfig;
    }
    get tune() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('tune')));
    }
    set tune(value) {
        this._tune = value;
    }
    resetTune() {
        this._tune = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tuneInput() {
        return this._tune;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bound_issuer: cdktf.stringToTerraform(this._boundIssuer),
            default_role: cdktf.stringToTerraform(this._defaultRole),
            description: cdktf.stringToTerraform(this._description),
            jwks_ca_pem: cdktf.stringToTerraform(this._jwksCaPem),
            jwks_url: cdktf.stringToTerraform(this._jwksUrl),
            jwt_supported_algs: cdktf.listMapper(cdktf.stringToTerraform)(this._jwtSupportedAlgs),
            jwt_validation_pubkeys: cdktf.listMapper(cdktf.stringToTerraform)(this._jwtValidationPubkeys),
            local: cdktf.booleanToTerraform(this._local),
            namespace_in_state: cdktf.booleanToTerraform(this._namespaceInState),
            oidc_client_id: cdktf.stringToTerraform(this._oidcClientId),
            oidc_client_secret: cdktf.stringToTerraform(this._oidcClientSecret),
            oidc_discovery_ca_pem: cdktf.stringToTerraform(this._oidcDiscoveryCaPem),
            oidc_discovery_url: cdktf.stringToTerraform(this._oidcDiscoveryUrl),
            oidc_response_mode: cdktf.stringToTerraform(this._oidcResponseMode),
            oidc_response_types: cdktf.listMapper(cdktf.stringToTerraform)(this._oidcResponseTypes),
            path: cdktf.stringToTerraform(this._path),
            provider_config: cdktf.hashMapper(cdktf.stringToTerraform)(this._providerConfig),
            tune: cdktf.listMapper(jwtAuthBackendTuneToTerraform)(this._tune),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.JwtAuthBackend = JwtAuthBackend;
_a = JSII_RTTI_SYMBOL_1;
JwtAuthBackend[_a] = { fqn: "hashicorp_vault.JwtAuthBackend", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
JwtAuthBackend.tfResourceType = "vault_jwt_auth_backend";
//# sourceMappingURL=data:application/json;base64,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