import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JwtAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The value against which to match the iss claim in a JWT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#bound_issuer JwtAuthBackend#bound_issuer}
    */
    readonly boundIssuer?: string;
    /**
    * The default role to use if none is provided during login
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#default_role JwtAuthBackend#default_role}
    */
    readonly defaultRole?: string;
    /**
    * The description of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#description JwtAuthBackend#description}
    */
    readonly description?: string;
    /**
    * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#jwks_ca_pem JwtAuthBackend#jwks_ca_pem}
    */
    readonly jwksCaPem?: string;
    /**
    * JWKS URL to use to authenticate signatures. Cannot be used with 'oidc_discovery_url' or 'jwt_validation_pubkeys'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#jwks_url JwtAuthBackend#jwks_url}
    */
    readonly jwksUrl?: string;
    /**
    * A list of supported signing algorithms. Defaults to [RS256]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#jwt_supported_algs JwtAuthBackend#jwt_supported_algs}
    */
    readonly jwtSupportedAlgs?: string[];
    /**
    * A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used with 'jwks_url' or 'oidc_discovery_url'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#jwt_validation_pubkeys JwtAuthBackend#jwt_validation_pubkeys}
    */
    readonly jwtValidationPubkeys?: string[];
    /**
    * Specifies if the auth method is local only
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#local JwtAuthBackend#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#namespace_in_state JwtAuthBackend#namespace_in_state}
    */
    readonly namespaceInState?: boolean | cdktf.IResolvable;
    /**
    * Client ID used for OIDC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_client_id JwtAuthBackend#oidc_client_id}
    */
    readonly oidcClientId?: string;
    /**
    * Client Secret used for OIDC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_client_secret JwtAuthBackend#oidc_client_secret}
    */
    readonly oidcClientSecret?: string;
    /**
    * The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_discovery_ca_pem JwtAuthBackend#oidc_discovery_ca_pem}
    */
    readonly oidcDiscoveryCaPem?: string;
    /**
    * The OIDC Discovery URL, without any .well-known component (base path). Cannot be used with 'jwks_url' or 'jwt_validation_pubkeys'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_discovery_url JwtAuthBackend#oidc_discovery_url}
    */
    readonly oidcDiscoveryUrl?: string;
    /**
    * The response mode to be used in the OAuth2 request. Allowed values are 'query' and 'form_post'. Defaults to 'query'. If using Vault namespaces, and oidc_response_mode is 'form_post', then 'namespace_in_state' should be set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_response_mode JwtAuthBackend#oidc_response_mode}
    */
    readonly oidcResponseMode?: string;
    /**
    * The response types to request. Allowed values are 'code' and 'id_token'. Defaults to 'code'. Note: 'id_token' may only be used if 'oidc_response_mode' is set to 'form_post'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#oidc_response_types JwtAuthBackend#oidc_response_types}
    */
    readonly oidcResponseTypes?: string[];
    /**
    * path to mount the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#path JwtAuthBackend#path}
    */
    readonly path?: string;
    /**
    * Provider specific handling configuration
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#provider_config JwtAuthBackend#provider_config}
    */
    readonly providerConfig?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#tune JwtAuthBackend#tune}
    */
    readonly tune?: JwtAuthBackendTune[] | cdktf.IResolvable;
    /**
    * Type of backend. Can be either 'jwt' or 'oidc'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#type JwtAuthBackend#type}
    */
    readonly type?: string;
}
export interface JwtAuthBackendTune {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#allowed_response_headers JwtAuthBackend#allowed_response_headers}
    */
    readonly allowedResponseHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#audit_non_hmac_request_keys JwtAuthBackend#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#audit_non_hmac_response_keys JwtAuthBackend#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#default_lease_ttl JwtAuthBackend#default_lease_ttl}
    */
    readonly defaultLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#listing_visibility JwtAuthBackend#listing_visibility}
    */
    readonly listingVisibility?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#max_lease_ttl JwtAuthBackend#max_lease_ttl}
    */
    readonly maxLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#passthrough_request_headers JwtAuthBackend#passthrough_request_headers}
    */
    readonly passthroughRequestHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend#token_type JwtAuthBackend#token_type}
    */
    readonly tokenType?: string;
}
export declare function jwtAuthBackendTuneToTerraform(struct?: JwtAuthBackendTune | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend}
*/
export declare class JwtAuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_jwt_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend vault_jwt_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendConfig = {}
    */
    constructor(scope: Construct, id: string, config?: JwtAuthBackendConfig);
    get accessor(): string;
    private _boundIssuer?;
    get boundIssuer(): string;
    set boundIssuer(value: string);
    resetBoundIssuer(): void;
    get boundIssuerInput(): string | undefined;
    private _defaultRole?;
    get defaultRole(): string;
    set defaultRole(value: string);
    resetDefaultRole(): void;
    get defaultRoleInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _jwksCaPem?;
    get jwksCaPem(): string;
    set jwksCaPem(value: string);
    resetJwksCaPem(): void;
    get jwksCaPemInput(): string | undefined;
    private _jwksUrl?;
    get jwksUrl(): string;
    set jwksUrl(value: string);
    resetJwksUrl(): void;
    get jwksUrlInput(): string | undefined;
    private _jwtSupportedAlgs?;
    get jwtSupportedAlgs(): string[];
    set jwtSupportedAlgs(value: string[]);
    resetJwtSupportedAlgs(): void;
    get jwtSupportedAlgsInput(): string[] | undefined;
    private _jwtValidationPubkeys?;
    get jwtValidationPubkeys(): string[];
    set jwtValidationPubkeys(value: string[]);
    resetJwtValidationPubkeys(): void;
    get jwtValidationPubkeysInput(): string[] | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _namespaceInState?;
    get namespaceInState(): boolean | cdktf.IResolvable;
    set namespaceInState(value: boolean | cdktf.IResolvable);
    resetNamespaceInState(): void;
    get namespaceInStateInput(): boolean | cdktf.IResolvable | undefined;
    private _oidcClientId?;
    get oidcClientId(): string;
    set oidcClientId(value: string);
    resetOidcClientId(): void;
    get oidcClientIdInput(): string | undefined;
    private _oidcClientSecret?;
    get oidcClientSecret(): string;
    set oidcClientSecret(value: string);
    resetOidcClientSecret(): void;
    get oidcClientSecretInput(): string | undefined;
    private _oidcDiscoveryCaPem?;
    get oidcDiscoveryCaPem(): string;
    set oidcDiscoveryCaPem(value: string);
    resetOidcDiscoveryCaPem(): void;
    get oidcDiscoveryCaPemInput(): string | undefined;
    private _oidcDiscoveryUrl?;
    get oidcDiscoveryUrl(): string;
    set oidcDiscoveryUrl(value: string);
    resetOidcDiscoveryUrl(): void;
    get oidcDiscoveryUrlInput(): string | undefined;
    private _oidcResponseMode?;
    get oidcResponseMode(): string;
    set oidcResponseMode(value: string);
    resetOidcResponseMode(): void;
    get oidcResponseModeInput(): string | undefined;
    private _oidcResponseTypes?;
    get oidcResponseTypes(): string[];
    set oidcResponseTypes(value: string[]);
    resetOidcResponseTypes(): void;
    get oidcResponseTypesInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _providerConfig?;
    get providerConfig(): {
        [key: string]: string;
    };
    set providerConfig(value: {
        [key: string]: string;
    });
    resetProviderConfig(): void;
    get providerConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _tune?;
    get tune(): JwtAuthBackendTune[] | cdktf.IResolvable;
    set tune(value: JwtAuthBackendTune[] | cdktf.IResolvable);
    resetTune(): void;
    get tuneInput(): cdktf.IResolvable | JwtAuthBackendTune[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=jwt-auth-backend.d.ts.map