import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JwtAuthBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The list of allowed values for redirect_uri during OIDC logins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#allowed_redirect_uris JwtAuthBackendRole#allowed_redirect_uris}
    */
    readonly allowedRedirectUris?: string[];
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#backend JwtAuthBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * List of aud claims to match against. Any match is sufficient.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#bound_audiences JwtAuthBackendRole#bound_audiences}
    */
    readonly boundAudiences?: string[];
    /**
    * Map of claims/values to match against. The expected value may be a single string or a comma-separated string list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#bound_claims JwtAuthBackendRole#bound_claims}
    */
    readonly boundClaims?: {
        [key: string]: string;
    };
    /**
    * How to interpret values in the claims/values map: can be either "string" (exact match) or "glob" (wildcard match).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#bound_claims_type JwtAuthBackendRole#bound_claims_type}
    */
    readonly boundClaimsType?: string;
    /**
    * If set, requires that the sub claim matches this value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#bound_subject JwtAuthBackendRole#bound_subject}
    */
    readonly boundSubject?: string;
    /**
    * Map of claims (keys) to be copied to specified metadata fields (values).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#claim_mappings JwtAuthBackendRole#claim_mappings}
    */
    readonly claimMappings?: {
        [key: string]: string;
    };
    /**
    * The amount of leeway to add to all claims to account for clock skew, in seconds. Defaults to 60 seconds if set to 0 and can be disabled if set to -1. Only applicable with 'jwt' roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#clock_skew_leeway JwtAuthBackendRole#clock_skew_leeway}
    */
    readonly clockSkewLeeway?: number;
    /**
    * Disable bound claim value parsing. Useful when values contain commas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#disable_bound_claims_parsing JwtAuthBackendRole#disable_bound_claims_parsing}
    */
    readonly disableBoundClaimsParsing?: boolean | cdktf.IResolvable;
    /**
    * The amount of leeway to add to expiration (exp) claims to account for clock skew, in seconds. Defaults to 60 seconds if set to 0 and can be disabled if set to -1. Only applicable with 'jwt' roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#expiration_leeway JwtAuthBackendRole#expiration_leeway}
    */
    readonly expirationLeeway?: number;
    /**
    * The claim to use to uniquely identify the set of groups to which the user belongs; this will be used as the names for the Identity group aliases created due to a successful login. The claim value must be a list of strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#groups_claim JwtAuthBackendRole#groups_claim}
    */
    readonly groupsClaim?: string;
    /**
    * The amount of leeway to add to not before (nbf) claims to account for clock skew, in seconds. Defaults to 150 seconds if set to 0 and can be disabled if set to -1. Only applicable with 'jwt' roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#not_before_leeway JwtAuthBackendRole#not_before_leeway}
    */
    readonly notBeforeLeeway?: number;
    /**
    * List of OIDC scopes to be used with an OIDC role. The standard scope "openid" is automatically included and need not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#oidc_scopes JwtAuthBackendRole#oidc_scopes}
    */
    readonly oidcScopes?: string[];
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#role_name JwtAuthBackendRole#role_name}
    */
    readonly roleName: string;
    /**
    * Type of role, either "oidc" (default) or "jwt"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#role_type JwtAuthBackendRole#role_type}
    */
    readonly roleType?: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_bound_cidrs JwtAuthBackendRole#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_explicit_max_ttl JwtAuthBackendRole#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_max_ttl JwtAuthBackendRole#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_no_default_policy JwtAuthBackendRole#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_num_uses JwtAuthBackendRole#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_period JwtAuthBackendRole#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_policies JwtAuthBackendRole#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_ttl JwtAuthBackendRole#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#token_type JwtAuthBackendRole#token_type}
    */
    readonly tokenType?: string;
    /**
    * The claim to use to uniquely identify the user; this will be used as the name for the Identity entity alias created due to a successful login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#user_claim JwtAuthBackendRole#user_claim}
    */
    readonly userClaim: string;
    /**
    * Log received OIDC tokens and claims when debug-level logging is active. Not recommended in production since sensitive information may be present in OIDC responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role#verbose_oidc_logging JwtAuthBackendRole#verbose_oidc_logging}
    */
    readonly verboseOidcLogging?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role}
*/
export declare class JwtAuthBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_jwt_auth_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: JwtAuthBackendRoleConfig);
    private _allowedRedirectUris?;
    get allowedRedirectUris(): string[];
    set allowedRedirectUris(value: string[]);
    resetAllowedRedirectUris(): void;
    get allowedRedirectUrisInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _boundAudiences?;
    get boundAudiences(): string[];
    set boundAudiences(value: string[]);
    resetBoundAudiences(): void;
    get boundAudiencesInput(): string[] | undefined;
    private _boundClaims?;
    get boundClaims(): {
        [key: string]: string;
    };
    set boundClaims(value: {
        [key: string]: string;
    });
    resetBoundClaims(): void;
    get boundClaimsInput(): {
        [key: string]: string;
    } | undefined;
    private _boundClaimsType?;
    get boundClaimsType(): string;
    set boundClaimsType(value: string);
    resetBoundClaimsType(): void;
    get boundClaimsTypeInput(): string | undefined;
    private _boundSubject?;
    get boundSubject(): string;
    set boundSubject(value: string);
    resetBoundSubject(): void;
    get boundSubjectInput(): string | undefined;
    private _claimMappings?;
    get claimMappings(): {
        [key: string]: string;
    };
    set claimMappings(value: {
        [key: string]: string;
    });
    resetClaimMappings(): void;
    get claimMappingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clockSkewLeeway?;
    get clockSkewLeeway(): number;
    set clockSkewLeeway(value: number);
    resetClockSkewLeeway(): void;
    get clockSkewLeewayInput(): number | undefined;
    private _disableBoundClaimsParsing?;
    get disableBoundClaimsParsing(): boolean | cdktf.IResolvable;
    set disableBoundClaimsParsing(value: boolean | cdktf.IResolvable);
    resetDisableBoundClaimsParsing(): void;
    get disableBoundClaimsParsingInput(): boolean | cdktf.IResolvable | undefined;
    private _expirationLeeway?;
    get expirationLeeway(): number;
    set expirationLeeway(value: number);
    resetExpirationLeeway(): void;
    get expirationLeewayInput(): number | undefined;
    private _groupsClaim?;
    get groupsClaim(): string;
    set groupsClaim(value: string);
    resetGroupsClaim(): void;
    get groupsClaimInput(): string | undefined;
    get id(): string;
    private _notBeforeLeeway?;
    get notBeforeLeeway(): number;
    set notBeforeLeeway(value: number);
    resetNotBeforeLeeway(): void;
    get notBeforeLeewayInput(): number | undefined;
    private _oidcScopes?;
    get oidcScopes(): string[];
    set oidcScopes(value: string[]);
    resetOidcScopes(): void;
    get oidcScopesInput(): string[] | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _roleType?;
    get roleType(): string;
    set roleType(value: string);
    resetRoleType(): void;
    get roleTypeInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    private _userClaim?;
    get userClaim(): string;
    set userClaim(value: string);
    get userClaimInput(): string | undefined;
    private _verboseOidcLogging?;
    get verboseOidcLogging(): boolean | cdktf.IResolvable;
    set verboseOidcLogging(value: boolean | cdktf.IResolvable);
    resetVerboseOidcLogging(): void;
    get verboseOidcLoggingInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=jwt-auth-backend-role.d.ts.map