import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityOidcProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * The client IDs that are permitted to use the provider. If empty, no clients are allowed. If "*", all clients are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#allowed_client_ids IdentityOidcProvider#allowed_client_ids}
    */
    readonly allowedClientIds?: string[];
    /**
    * Set to true if the issuer endpoint uses HTTPS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#https_enabled IdentityOidcProvider#https_enabled}
    */
    readonly httpsEnabled?: boolean | cdktf.IResolvable;
    /**
    * The host for the issuer. Can be either host or host:port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#issuer_host IdentityOidcProvider#issuer_host}
    */
    readonly issuerHost?: string;
    /**
    * The name of the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#name IdentityOidcProvider#name}
    */
    readonly name: string;
    /**
    * The scopes available for requesting on the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider#scopes_supported IdentityOidcProvider#scopes_supported}
    */
    readonly scopesSupported?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider vault_identity_oidc_provider}
*/
export declare class IdentityOidcProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_oidc_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_provider vault_identity_oidc_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityOidcProviderConfig
    */
    constructor(scope: Construct, id: string, config: IdentityOidcProviderConfig);
    private _allowedClientIds?;
    get allowedClientIds(): string[];
    set allowedClientIds(value: string[]);
    resetAllowedClientIds(): void;
    get allowedClientIdsInput(): string[] | undefined;
    private _httpsEnabled?;
    get httpsEnabled(): boolean | cdktf.IResolvable;
    set httpsEnabled(value: boolean | cdktf.IResolvable);
    resetHttpsEnabled(): void;
    get httpsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get issuer(): string;
    private _issuerHost?;
    get issuerHost(): string;
    set issuerHost(value: string);
    resetIssuerHost(): void;
    get issuerHostInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopesSupported?;
    get scopesSupported(): string[];
    set scopesSupported(value: string[]);
    resetScopesSupported(): void;
    get scopesSupportedInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-oidc-provider.d.ts.map