import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityOidcKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Signing algorithm to use. Signing algorithm to use. Allowed values are: RS256 (default), RS384, RS512, ES256, ES384, ES512, EdDSA.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key#algorithm IdentityOidcKey#algorithm}
    */
    readonly algorithm?: string;
    /**
    * Array of role client ids allowed to use this key for signing. If empty, no roles are allowed. If "*", all roles are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key#allowed_client_ids IdentityOidcKey#allowed_client_ids}
    */
    readonly allowedClientIds?: string[];
    /**
    * Name of the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key#name IdentityOidcKey#name}
    */
    readonly name: string;
    /**
    * How often to generate a new signing key in number of seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key#rotation_period IdentityOidcKey#rotation_period}
    */
    readonly rotationPeriod?: number;
    /**
    * Controls how long the public portion of a signing key will be available for verification after being rotated in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key#verification_ttl IdentityOidcKey#verification_ttl}
    */
    readonly verificationTtl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key vault_identity_oidc_key}
*/
export declare class IdentityOidcKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_oidc_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key vault_identity_oidc_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityOidcKeyConfig
    */
    constructor(scope: Construct, id: string, config: IdentityOidcKeyConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _allowedClientIds?;
    get allowedClientIds(): string[];
    set allowedClientIds(value: string[]);
    resetAllowedClientIds(): void;
    get allowedClientIdsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): number;
    set rotationPeriod(value: number);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): number | undefined;
    private _verificationTtl?;
    get verificationTtl(): number;
    set verificationTtl(value: number);
    resetVerificationTtl(): void;
    get verificationTtlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-oidc-key.d.ts.map