import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityOidcKeyAllowedClientIdConfig extends cdktf.TerraformMetaArguments {
    /**
    * Role Client ID allowed to use the key for signing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key_allowed_client_id#allowed_client_id IdentityOidcKeyAllowedClientId#allowed_client_id}
    */
    readonly allowedClientId: string;
    /**
    * Name of the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key_allowed_client_id#key_name IdentityOidcKeyAllowedClientId#key_name}
    */
    readonly keyName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key_allowed_client_id vault_identity_oidc_key_allowed_client_id}
*/
export declare class IdentityOidcKeyAllowedClientId extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_oidc_key_allowed_client_id";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_key_allowed_client_id vault_identity_oidc_key_allowed_client_id} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityOidcKeyAllowedClientIdConfig
    */
    constructor(scope: Construct, id: string, config: IdentityOidcKeyAllowedClientIdConfig);
    private _allowedClientId?;
    get allowedClientId(): string;
    set allowedClientId(value: string);
    get allowedClientIdInput(): string | undefined;
    get id(): string;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-oidc-key-allowed-client-id.d.ts.map