import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityOidcClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * The time-to-live for access tokens obtained by the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#access_token_ttl IdentityOidcClient#access_token_ttl}
    */
    readonly accessTokenTtl?: number;
    /**
    * A list of assignment resources associated with the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#assignments IdentityOidcClient#assignments}
    */
    readonly assignments?: string[];
    /**
    * The client type based on its ability to maintain confidentiality of credentials.Defaults to 'confidential'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#client_type IdentityOidcClient#client_type}
    */
    readonly clientType?: string;
    /**
    * The time-to-live for ID tokens obtained by the client. The value should be less than the verification_ttl on the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#id_token_ttl IdentityOidcClient#id_token_ttl}
    */
    readonly idTokenTtl?: number;
    /**
    * A reference to a named key resource in Vault. This cannot be modified after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#key IdentityOidcClient#key}
    */
    readonly key?: string;
    /**
    * The name of the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#name IdentityOidcClient#name}
    */
    readonly name: string;
    /**
    * Redirection URI values used by the client. One of these values must exactly match the redirect_uri parameter value used in each authentication request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client#redirect_uris IdentityOidcClient#redirect_uris}
    */
    readonly redirectUris?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client vault_identity_oidc_client}
*/
export declare class IdentityOidcClient extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_oidc_client";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_oidc_client vault_identity_oidc_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityOidcClientConfig
    */
    constructor(scope: Construct, id: string, config: IdentityOidcClientConfig);
    private _accessTokenTtl?;
    get accessTokenTtl(): number;
    set accessTokenTtl(value: number);
    resetAccessTokenTtl(): void;
    get accessTokenTtlInput(): number | undefined;
    private _assignments?;
    get assignments(): string[];
    set assignments(value: string[]);
    resetAssignments(): void;
    get assignmentsInput(): string[] | undefined;
    get clientId(): string;
    get clientSecret(): string;
    private _clientType?;
    get clientType(): string;
    set clientType(value: string);
    resetClientType(): void;
    get clientTypeInput(): string | undefined;
    get id(): string;
    private _idTokenTtl?;
    get idTokenTtl(): number;
    set idTokenTtl(value: number);
    resetIdTokenTtl(): void;
    get idTokenTtlInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-oidc-client.d.ts.map