import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityGroupPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Should the resource manage policies exclusively? Beware of race conditions when disabling exclusive management
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_policies#exclusive IdentityGroupPolicies#exclusive}
    */
    readonly exclusive?: boolean | cdktf.IResolvable;
    /**
    * ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_policies#group_id IdentityGroupPolicies#group_id}
    */
    readonly groupId: string;
    /**
    * Policies to be tied to the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_policies#policies IdentityGroupPolicies#policies}
    */
    readonly policies: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_group_policies vault_identity_group_policies}
*/
export declare class IdentityGroupPolicies extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_group_policies";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_group_policies vault_identity_group_policies} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityGroupPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: IdentityGroupPoliciesConfig);
    private _exclusive?;
    get exclusive(): boolean | cdktf.IResolvable;
    set exclusive(value: boolean | cdktf.IResolvable);
    resetExclusive(): void;
    get exclusiveInput(): boolean | cdktf.IResolvable | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    get groupName(): string;
    get id(): string;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    get policiesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-group-policies.d.ts.map