import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityGroupAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the group to which this is an alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#canonical_id IdentityGroupAlias#canonical_id}
    */
    readonly canonicalId: string;
    /**
    * Mount accessor to which this alias belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#mount_accessor IdentityGroupAlias#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the group alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias#name IdentityGroupAlias#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias vault_identity_group_alias}
*/
export declare class IdentityGroupAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_group_alias";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_group_alias vault_identity_group_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityGroupAliasConfig
    */
    constructor(scope: Construct, id: string, config: IdentityGroupAliasConfig);
    private _canonicalId?;
    get canonicalId(): string;
    set canonicalId(value: string);
    get canonicalIdInput(): string | undefined;
    get id(): string;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-group-alias.d.ts.map