import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityEntityPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_policies#entity_id IdentityEntityPolicies#entity_id}
    */
    readonly entityId: string;
    /**
    * Should the resource manage policies exclusively
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_policies#exclusive IdentityEntityPolicies#exclusive}
    */
    readonly exclusive?: boolean | cdktf.IResolvable;
    /**
    * Policies to be tied to the entity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_policies#policies IdentityEntityPolicies#policies}
    */
    readonly policies: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_policies vault_identity_entity_policies}
*/
export declare class IdentityEntityPolicies extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_entity_policies";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_policies vault_identity_entity_policies} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityEntityPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: IdentityEntityPoliciesConfig);
    private _entityId?;
    get entityId(): string;
    set entityId(value: string);
    get entityIdInput(): string | undefined;
    get entityName(): string;
    private _exclusive?;
    get exclusive(): boolean | cdktf.IResolvable;
    set exclusive(value: boolean | cdktf.IResolvable);
    resetExclusive(): void;
    get exclusiveInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    get policiesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-entity-policies.d.ts.map