import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityEntityAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the entity to which this is an alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#canonical_id IdentityEntityAlias#canonical_id}
    */
    readonly canonicalId: string;
    /**
    * Custom metadata to be associated with this alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#custom_metadata IdentityEntityAlias#custom_metadata}
    */
    readonly customMetadata?: {
        [key: string]: string;
    };
    /**
    * Mount accessor to which this alias belongs toMount accessor to which this alias belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#mount_accessor IdentityEntityAlias#mount_accessor}
    */
    readonly mountAccessor: string;
    /**
    * Name of the entity alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias#name IdentityEntityAlias#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias vault_identity_entity_alias}
*/
export declare class IdentityEntityAlias extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_identity_entity_alias";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/identity_entity_alias vault_identity_entity_alias} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityEntityAliasConfig
    */
    constructor(scope: Construct, id: string, config: IdentityEntityAliasConfig);
    private _canonicalId?;
    get canonicalId(): string;
    set canonicalId(value: string);
    get canonicalIdInput(): string | undefined;
    private _customMetadata?;
    get customMetadata(): {
        [key: string]: string;
    };
    set customMetadata(value: {
        [key: string]: string;
    });
    resetCustomMetadata(): void;
    get customMetadataInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _mountAccessor?;
    get mountAccessor(): string;
    set mountAccessor(value: string);
    get mountAccessorInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=identity-entity-alias.d.ts.map