import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GithubUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth backend to which user mapping will be congigured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_user#backend GithubUser#backend}
    */
    readonly backend?: string;
    /**
    * Policies to be assigned to this user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_user#policies GithubUser#policies}
    */
    readonly policies?: string[];
    /**
    * GitHub user name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_user#user GithubUser#user}
    */
    readonly user: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/github_user vault_github_user}
*/
export declare class GithubUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_github_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/github_user vault_github_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GithubUserConfig
    */
    constructor(scope: Construct, id: string, config: GithubUserConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get id(): string;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=github-user.d.ts.map