import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GithubTeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth backend to which team mapping will be congigured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_team#backend GithubTeam#backend}
    */
    readonly backend?: string;
    /**
    * Policies to be assigned to this team.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_team#policies GithubTeam#policies}
    */
    readonly policies?: string[];
    /**
    * GitHub team name in "slugified" format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_team#team GithubTeam#team}
    */
    readonly team: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/github_team vault_github_team}
*/
export declare class GithubTeam extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_github_team";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/github_team vault_github_team} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GithubTeamConfig
    */
    constructor(scope: Construct, id: string, config: GithubTeamConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    get id(): string;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _team?;
    get team(): string;
    set team(value: string);
    get teamInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=github-team.d.ts.map