import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GithubAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The API endpoint to use. Useful if you are running GitHub Enterprise or an API-compatible authentication server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#base_url GithubAuthBackend#base_url}
    */
    readonly baseUrl?: string;
    /**
    * Specifies the description of the mount. This overrides the current stored value, if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#description GithubAuthBackend#description}
    */
    readonly description?: string;
    /**
    * The organization users must be part of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#organization GithubAuthBackend#organization}
    */
    readonly organization: string;
    /**
    * The ID of the organization users must be part of. Vault will attempt to fetch and set this value if it is not provided (vault-1.10+)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#organization_id GithubAuthBackend#organization_id}
    */
    readonly organizationId?: number;
    /**
    * Path where the auth backend is mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#path GithubAuthBackend#path}
    */
    readonly path?: string;
    /**
    * Specifies the blocks of IP addresses which are allowed to use the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_bound_cidrs GithubAuthBackend#token_bound_cidrs}
    */
    readonly tokenBoundCidrs?: string[];
    /**
    * Generated Token's Explicit Maximum TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_explicit_max_ttl GithubAuthBackend#token_explicit_max_ttl}
    */
    readonly tokenExplicitMaxTtl?: number;
    /**
    * The maximum lifetime of the generated token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_max_ttl GithubAuthBackend#token_max_ttl}
    */
    readonly tokenMaxTtl?: number;
    /**
    * If true, the 'default' policy will not automatically be added to generated tokens
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_no_default_policy GithubAuthBackend#token_no_default_policy}
    */
    readonly tokenNoDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * The maximum number of times a token may be used, a value of zero means unlimited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_num_uses GithubAuthBackend#token_num_uses}
    */
    readonly tokenNumUses?: number;
    /**
    * Generated Token's Period
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_period GithubAuthBackend#token_period}
    */
    readonly tokenPeriod?: number;
    /**
    * Generated Token's Policies
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_policies GithubAuthBackend#token_policies}
    */
    readonly tokenPolicies?: string[];
    /**
    * The initial ttl of the token to generate in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_ttl GithubAuthBackend#token_ttl}
    */
    readonly tokenTtl?: number;
    /**
    * The type of token to generate, service or batch
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_type GithubAuthBackend#token_type}
    */
    readonly tokenType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#tune GithubAuthBackend#tune}
    */
    readonly tune?: GithubAuthBackendTune[] | cdktf.IResolvable;
}
export interface GithubAuthBackendTune {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#allowed_response_headers GithubAuthBackend#allowed_response_headers}
    */
    readonly allowedResponseHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#audit_non_hmac_request_keys GithubAuthBackend#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#audit_non_hmac_response_keys GithubAuthBackend#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#default_lease_ttl GithubAuthBackend#default_lease_ttl}
    */
    readonly defaultLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#listing_visibility GithubAuthBackend#listing_visibility}
    */
    readonly listingVisibility?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#max_lease_ttl GithubAuthBackend#max_lease_ttl}
    */
    readonly maxLeaseTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#passthrough_request_headers GithubAuthBackend#passthrough_request_headers}
    */
    readonly passthroughRequestHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend#token_type GithubAuthBackend#token_type}
    */
    readonly tokenType?: string;
}
export declare function githubAuthBackendTuneToTerraform(struct?: GithubAuthBackendTune | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend}
*/
export declare class GithubAuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_github_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/github_auth_backend vault_github_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GithubAuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: GithubAuthBackendConfig);
    get accessor(): string;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationId?;
    get organizationId(): number;
    set organizationId(value: number);
    resetOrganizationId(): void;
    get organizationIdInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _tokenBoundCidrs?;
    get tokenBoundCidrs(): string[];
    set tokenBoundCidrs(value: string[]);
    resetTokenBoundCidrs(): void;
    get tokenBoundCidrsInput(): string[] | undefined;
    private _tokenExplicitMaxTtl?;
    get tokenExplicitMaxTtl(): number;
    set tokenExplicitMaxTtl(value: number);
    resetTokenExplicitMaxTtl(): void;
    get tokenExplicitMaxTtlInput(): number | undefined;
    private _tokenMaxTtl?;
    get tokenMaxTtl(): number;
    set tokenMaxTtl(value: number);
    resetTokenMaxTtl(): void;
    get tokenMaxTtlInput(): number | undefined;
    private _tokenNoDefaultPolicy?;
    get tokenNoDefaultPolicy(): boolean | cdktf.IResolvable;
    set tokenNoDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetTokenNoDefaultPolicy(): void;
    get tokenNoDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenNumUses?;
    get tokenNumUses(): number;
    set tokenNumUses(value: number);
    resetTokenNumUses(): void;
    get tokenNumUsesInput(): number | undefined;
    private _tokenPeriod?;
    get tokenPeriod(): number;
    set tokenPeriod(value: number);
    resetTokenPeriod(): void;
    get tokenPeriodInput(): number | undefined;
    private _tokenPolicies?;
    get tokenPolicies(): string[];
    set tokenPolicies(value: string[]);
    resetTokenPolicies(): void;
    get tokenPoliciesInput(): string[] | undefined;
    private _tokenTtl?;
    get tokenTtl(): number;
    set tokenTtl(value: number);
    resetTokenTtl(): void;
    get tokenTtlInput(): number | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    private _tune?;
    get tune(): GithubAuthBackendTune[] | cdktf.IResolvable;
    set tune(value: GithubAuthBackendTune[] | cdktf.IResolvable);
    resetTune(): void;
    get tuneInput(): cdktf.IResolvable | GithubAuthBackendTune[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=github-auth-backend.d.ts.map