import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GenericSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * JSON-encoded secret data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#data_json GenericSecret#data_json}
    */
    readonly dataJson: string;
    /**
    * Only applicable for kv-v2 stores. If set, permanently deletes all versions for the specified key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#delete_all_versions GenericSecret#delete_all_versions}
    */
    readonly deleteAllVersions?: boolean | cdktf.IResolvable;
    /**
    * Don't attempt to read the token from Vault if true; drift won't be detected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#disable_read GenericSecret#disable_read}
    */
    readonly disableRead?: boolean | cdktf.IResolvable;
    /**
    * Full path where the generic secret will be written.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#path GenericSecret#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/generic_secret vault_generic_secret}
*/
export declare class GenericSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_generic_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/generic_secret vault_generic_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GenericSecretConfig
    */
    constructor(scope: Construct, id: string, config: GenericSecretConfig);
    data(key: string): string | cdktf.IResolvable;
    private _dataJson?;
    get dataJson(): string;
    set dataJson(value: string);
    get dataJsonInput(): string | undefined;
    private _deleteAllVersions?;
    get deleteAllVersions(): boolean | cdktf.IResolvable;
    set deleteAllVersions(value: boolean | cdktf.IResolvable);
    resetDeleteAllVersions(): void;
    get deleteAllVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _disableRead?;
    get disableRead(): boolean | cdktf.IResolvable;
    set disableRead(value: boolean | cdktf.IResolvable);
    resetDisableRead(): void;
    get disableReadInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=generic-secret.d.ts.map