import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GenericEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * JSON-encoded data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#data_json GenericEndpoint#data_json}
    */
    readonly dataJson: string;
    /**
    * Don't attempt to delete the path from Vault if true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#disable_delete GenericEndpoint#disable_delete}
    */
    readonly disableDelete?: boolean | cdktf.IResolvable;
    /**
    * Don't attempt to read the path from Vault if true; drift won't be detected
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#disable_read GenericEndpoint#disable_read}
    */
    readonly disableRead?: boolean | cdktf.IResolvable;
    /**
    * When reading, disregard fields not present in data_json
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#ignore_absent_fields GenericEndpoint#ignore_absent_fields}
    */
    readonly ignoreAbsentFields?: boolean | cdktf.IResolvable;
    /**
    * Full path where to the endpoint that will be written
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#path GenericEndpoint#path}
    */
    readonly path: string;
    /**
    * Top-level fields returned by write to persist in state
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint#write_fields GenericEndpoint#write_fields}
    */
    readonly writeFields?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint vault_generic_endpoint}
*/
export declare class GenericEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_generic_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/generic_endpoint vault_generic_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GenericEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GenericEndpointConfig);
    private _dataJson?;
    get dataJson(): string;
    set dataJson(value: string);
    get dataJsonInput(): string | undefined;
    private _disableDelete?;
    get disableDelete(): boolean | cdktf.IResolvable;
    set disableDelete(value: boolean | cdktf.IResolvable);
    resetDisableDelete(): void;
    get disableDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _disableRead?;
    get disableRead(): boolean | cdktf.IResolvable;
    set disableRead(value: boolean | cdktf.IResolvable);
    resetDisableRead(): void;
    get disableReadInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _ignoreAbsentFields?;
    get ignoreAbsentFields(): boolean | cdktf.IResolvable;
    set ignoreAbsentFields(value: boolean | cdktf.IResolvable);
    resetIgnoreAbsentFields(): void;
    get ignoreAbsentFieldsInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    writeData(key: string): string | cdktf.IResolvable;
    get writeDataJson(): string;
    private _writeFields?;
    get writeFields(): string[];
    set writeFields(value: string[]);
    resetWriteFields(): void;
    get writeFieldsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=generic-endpoint.d.ts.map