import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpSecretStaticAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path where the GCP secrets engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#backend GcpSecretStaticAccount#backend}
    */
    readonly backend: string;
    /**
    * Type of secret generated for this static account. Defaults to `access_token`. Accepted values: `access_token`, `service_account_key`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#secret_type GcpSecretStaticAccount#secret_type}
    */
    readonly secretType?: string;
    /**
    * Email of the GCP service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#service_account_email GcpSecretStaticAccount#service_account_email}
    */
    readonly serviceAccountEmail: string;
    /**
    * Name of the Static Account to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#static_account GcpSecretStaticAccount#static_account}
    */
    readonly staticAccount: string;
    /**
    * List of OAuth scopes to assign to `access_token` secrets generated under this static account (`access_token` static accounts only)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#token_scopes GcpSecretStaticAccount#token_scopes}
    */
    readonly tokenScopes?: string[];
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#binding GcpSecretStaticAccount#binding}
    */
    readonly binding?: GcpSecretStaticAccountBinding[] | cdktf.IResolvable;
}
export interface GcpSecretStaticAccountBinding {
    /**
    * Resource name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#resource GcpSecretStaticAccount#resource}
    */
    readonly resource: string;
    /**
    * List of roles to apply to the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account#roles GcpSecretStaticAccount#roles}
    */
    readonly roles: string[];
}
export declare function gcpSecretStaticAccountBindingToTerraform(struct?: GcpSecretStaticAccountBinding | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account vault_gcp_secret_static_account}
*/
export declare class GcpSecretStaticAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_secret_static_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_static_account vault_gcp_secret_static_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpSecretStaticAccountConfig
    */
    constructor(scope: Construct, id: string, config: GcpSecretStaticAccountConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
    get serviceAccountProject(): string;
    private _staticAccount?;
    get staticAccount(): string;
    set staticAccount(value: string);
    get staticAccountInput(): string | undefined;
    private _tokenScopes?;
    get tokenScopes(): string[];
    set tokenScopes(value: string[]);
    resetTokenScopes(): void;
    get tokenScopesInput(): string[] | undefined;
    private _binding?;
    get binding(): GcpSecretStaticAccountBinding[] | cdktf.IResolvable;
    set binding(value: GcpSecretStaticAccountBinding[] | cdktf.IResolvable);
    resetBinding(): void;
    get bindingInput(): cdktf.IResolvable | GcpSecretStaticAccountBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=gcp-secret-static-account.d.ts.map