import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpSecretRolesetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path where the GCP secrets engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#backend GcpSecretRoleset#backend}
    */
    readonly backend: string;
    /**
    * Name of the GCP project that this roleset's service account will belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#project GcpSecretRoleset#project}
    */
    readonly project: string;
    /**
    * Name of the RoleSet to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#roleset GcpSecretRoleset#roleset}
    */
    readonly roleset: string;
    /**
    * Type of secret generated for this role set. Defaults to `access_token`. Accepted values: `access_token`, `service_account_key`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#secret_type GcpSecretRoleset#secret_type}
    */
    readonly secretType?: string;
    /**
    * List of OAuth scopes to assign to `access_token` secrets generated under this role set (`access_token` role sets only)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#token_scopes GcpSecretRoleset#token_scopes}
    */
    readonly tokenScopes?: string[];
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#binding GcpSecretRoleset#binding}
    */
    readonly binding: GcpSecretRolesetBinding[] | cdktf.IResolvable;
}
export interface GcpSecretRolesetBinding {
    /**
    * Resource name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#resource GcpSecretRoleset#resource}
    */
    readonly resource: string;
    /**
    * List of roles to apply to the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#roles GcpSecretRoleset#roles}
    */
    readonly roles: string[];
}
export declare function gcpSecretRolesetBindingToTerraform(struct?: GcpSecretRolesetBinding | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset vault_gcp_secret_roleset}
*/
export declare class GcpSecretRoleset extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_secret_roleset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset vault_gcp_secret_roleset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpSecretRolesetConfig
    */
    constructor(scope: Construct, id: string, config: GcpSecretRolesetConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _roleset?;
    get roleset(): string;
    set roleset(value: string);
    get rolesetInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    get serviceAccountEmail(): string;
    private _tokenScopes?;
    get tokenScopes(): string[];
    set tokenScopes(value: string[]);
    resetTokenScopes(): void;
    get tokenScopesInput(): string[] | undefined;
    private _binding?;
    get binding(): GcpSecretRolesetBinding[] | cdktf.IResolvable;
    set binding(value: GcpSecretRolesetBinding[] | cdktf.IResolvable);
    get bindingInput(): cdktf.IResolvable | GcpSecretRolesetBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=gcp-secret-roleset.d.ts.map