import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EgpPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enforcement level of Sentinel policy. Can be one of: 'advisory', 'soft-mandatory' or 'hard-mandatory'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/egp_policy#enforcement_level EgpPolicy#enforcement_level}
    */
    readonly enforcementLevel: string;
    /**
    * Name of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/egp_policy#name EgpPolicy#name}
    */
    readonly name: string;
    /**
    * List of paths to which the policy will be applied
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/egp_policy#paths EgpPolicy#paths}
    */
    readonly paths: string[];
    /**
    * The policy document
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/egp_policy#policy EgpPolicy#policy}
    */
    readonly policy: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/egp_policy vault_egp_policy}
*/
export declare class EgpPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_egp_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/egp_policy vault_egp_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EgpPolicyConfig
    */
    constructor(scope: Construct, id: string, config: EgpPolicyConfig);
    private _enforcementLevel?;
    get enforcementLevel(): string;
    set enforcementLevel(value: string);
    get enforcementLevelInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    get pathsInput(): string[] | undefined;
    private _policy?;
    get policy(): string;
    set policy(value: string);
    get policyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=egp-policy.d.ts.map