"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecretsMount = exports.databaseSecretsMountSnowflakeToTerraform = exports.databaseSecretsMountRedshiftToTerraform = exports.databaseSecretsMountPostgresqlToTerraform = exports.databaseSecretsMountOracleToTerraform = exports.databaseSecretsMountMysqlRdsToTerraform = exports.databaseSecretsMountMysqlLegacyToTerraform = exports.databaseSecretsMountMysqlAuroraToTerraform = exports.databaseSecretsMountMysqlToTerraform = exports.databaseSecretsMountMssqlToTerraform = exports.databaseSecretsMountMongodbatlasToTerraform = exports.databaseSecretsMountMongodbToTerraform = exports.databaseSecretsMountInfluxdbToTerraform = exports.databaseSecretsMountHanaToTerraform = exports.databaseSecretsMountElasticsearchToTerraform = exports.databaseSecretsMountCouchbaseToTerraform = exports.databaseSecretsMountCassandraToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function databaseSecretsMountCassandraToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connect_timeout: cdktf.numberToTerraform(struct.connectTimeout),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        hosts: cdktf.listMapper(cdktf.stringToTerraform)(struct.hosts),
        insecure_tls: cdktf.booleanToTerraform(struct.insecureTls),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        pem_bundle: cdktf.stringToTerraform(struct.pemBundle),
        pem_json: cdktf.stringToTerraform(struct.pemJson),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        port: cdktf.numberToTerraform(struct.port),
        protocol_version: cdktf.numberToTerraform(struct.protocolVersion),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        tls: cdktf.booleanToTerraform(struct.tls),
        username: cdktf.stringToTerraform(struct.username),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountCassandraToTerraform = databaseSecretsMountCassandraToTerraform;
function databaseSecretsMountCouchbaseToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        base64_pem: cdktf.stringToTerraform(struct.base64Pem),
        bucket_name: cdktf.stringToTerraform(struct.bucketName),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        hosts: cdktf.listMapper(cdktf.stringToTerraform)(struct.hosts),
        insecure_tls: cdktf.booleanToTerraform(struct.insecureTls),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        tls: cdktf.booleanToTerraform(struct.tls),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountCouchbaseToTerraform = databaseSecretsMountCouchbaseToTerraform;
function databaseSecretsMountElasticsearchToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        ca_cert: cdktf.stringToTerraform(struct.caCert),
        ca_path: cdktf.stringToTerraform(struct.caPath),
        client_cert: cdktf.stringToTerraform(struct.clientCert),
        client_key: cdktf.stringToTerraform(struct.clientKey),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        insecure: cdktf.booleanToTerraform(struct.insecure),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        tls_server_name: cdktf.stringToTerraform(struct.tlsServerName),
        url: cdktf.stringToTerraform(struct.url),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountElasticsearchToTerraform = databaseSecretsMountElasticsearchToTerraform;
function databaseSecretsMountHanaToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountHanaToTerraform = databaseSecretsMountHanaToTerraform;
function databaseSecretsMountInfluxdbToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connect_timeout: cdktf.numberToTerraform(struct.connectTimeout),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        host: cdktf.stringToTerraform(struct.host),
        insecure_tls: cdktf.booleanToTerraform(struct.insecureTls),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        pem_bundle: cdktf.stringToTerraform(struct.pemBundle),
        pem_json: cdktf.stringToTerraform(struct.pemJson),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        port: cdktf.numberToTerraform(struct.port),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        tls: cdktf.booleanToTerraform(struct.tls),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountInfluxdbToTerraform = databaseSecretsMountInfluxdbToTerraform;
function databaseSecretsMountMongodbToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMongodbToTerraform = databaseSecretsMountMongodbToTerraform;
function databaseSecretsMountMongodbatlasToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        name: cdktf.stringToTerraform(struct.name),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        private_key: cdktf.stringToTerraform(struct.privateKey),
        project_id: cdktf.stringToTerraform(struct.projectId),
        public_key: cdktf.stringToTerraform(struct.publicKey),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMongodbatlasToTerraform = databaseSecretsMountMongodbatlasToTerraform;
function databaseSecretsMountMssqlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        contained_db: cdktf.booleanToTerraform(struct.containedDb),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        disable_escaping: cdktf.booleanToTerraform(struct.disableEscaping),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMssqlToTerraform = databaseSecretsMountMssqlToTerraform;
function databaseSecretsMountMysqlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        tls_ca: cdktf.stringToTerraform(struct.tlsCa),
        tls_certificate_key: cdktf.stringToTerraform(struct.tlsCertificateKey),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMysqlToTerraform = databaseSecretsMountMysqlToTerraform;
function databaseSecretsMountMysqlAuroraToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMysqlAuroraToTerraform = databaseSecretsMountMysqlAuroraToTerraform;
function databaseSecretsMountMysqlLegacyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMysqlLegacyToTerraform = databaseSecretsMountMysqlLegacyToTerraform;
function databaseSecretsMountMysqlRdsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountMysqlRdsToTerraform = databaseSecretsMountMysqlRdsToTerraform;
function databaseSecretsMountOracleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountOracleToTerraform = databaseSecretsMountOracleToTerraform;
function databaseSecretsMountPostgresqlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountPostgresqlToTerraform = databaseSecretsMountPostgresqlToTerraform;
function databaseSecretsMountRedshiftToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountRedshiftToTerraform = databaseSecretsMountRedshiftToTerraform;
function databaseSecretsMountSnowflakeToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_roles: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedRoles),
        connection_url: cdktf.stringToTerraform(struct.connectionUrl),
        data: cdktf.hashMapper(cdktf.stringToTerraform)(struct.data),
        max_connection_lifetime: cdktf.numberToTerraform(struct.maxConnectionLifetime),
        max_idle_connections: cdktf.numberToTerraform(struct.maxIdleConnections),
        max_open_connections: cdktf.numberToTerraform(struct.maxOpenConnections),
        name: cdktf.stringToTerraform(struct.name),
        password: cdktf.stringToTerraform(struct.password),
        plugin_name: cdktf.stringToTerraform(struct.pluginName),
        root_rotation_statements: cdktf.listMapper(cdktf.stringToTerraform)(struct.rootRotationStatements),
        username: cdktf.stringToTerraform(struct.username),
        username_template: cdktf.stringToTerraform(struct.usernameTemplate),
        verify_connection: cdktf.booleanToTerraform(struct.verifyConnection),
    };
}
exports.databaseSecretsMountSnowflakeToTerraform = databaseSecretsMountSnowflakeToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount vault_database_secrets_mount}
*/
class DatabaseSecretsMount extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount vault_database_secrets_mount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseSecretsMountConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_database_secrets_mount',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._auditNonHmacRequestKeys = config.auditNonHmacRequestKeys;
        this._auditNonHmacResponseKeys = config.auditNonHmacResponseKeys;
        this._defaultLeaseTtlSeconds = config.defaultLeaseTtlSeconds;
        this._description = config.description;
        this._externalEntropyAccess = config.externalEntropyAccess;
        this._local = config.local;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._options = config.options;
        this._path = config.path;
        this._sealWrap = config.sealWrap;
        this._cassandra = config.cassandra;
        this._couchbase = config.couchbase;
        this._elasticsearch = config.elasticsearch;
        this._hana = config.hana;
        this._influxdb = config.influxdb;
        this._mongodb = config.mongodb;
        this._mongodbatlas = config.mongodbatlas;
        this._mssql = config.mssql;
        this._mysql = config.mysql;
        this._mysqlAurora = config.mysqlAurora;
        this._mysqlLegacy = config.mysqlLegacy;
        this._mysqlRds = config.mysqlRds;
        this._oracle = config.oracle;
        this._postgresql = config.postgresql;
        this._redshift = config.redshift;
        this._snowflake = config.snowflake;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accessor - computed: true, optional: false, required: false
    get accessor() {
        return this.getStringAttribute('accessor');
    }
    get auditNonHmacRequestKeys() {
        return this.getListAttribute('audit_non_hmac_request_keys');
    }
    set auditNonHmacRequestKeys(value) {
        this._auditNonHmacRequestKeys = value;
    }
    resetAuditNonHmacRequestKeys() {
        this._auditNonHmacRequestKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacRequestKeysInput() {
        return this._auditNonHmacRequestKeys;
    }
    get auditNonHmacResponseKeys() {
        return this.getListAttribute('audit_non_hmac_response_keys');
    }
    set auditNonHmacResponseKeys(value) {
        this._auditNonHmacResponseKeys = value;
    }
    resetAuditNonHmacResponseKeys() {
        this._auditNonHmacResponseKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get auditNonHmacResponseKeysInput() {
        return this._auditNonHmacResponseKeys;
    }
    get defaultLeaseTtlSeconds() {
        return this.getNumberAttribute('default_lease_ttl_seconds');
    }
    set defaultLeaseTtlSeconds(value) {
        this._defaultLeaseTtlSeconds = value;
    }
    resetDefaultLeaseTtlSeconds() {
        this._defaultLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlSecondsInput() {
        return this._defaultLeaseTtlSeconds;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // engine_count - computed: true, optional: false, required: false
    get engineCount() {
        return this.getNumberAttribute('engine_count');
    }
    get externalEntropyAccess() {
        return this.getBooleanAttribute('external_entropy_access');
    }
    set externalEntropyAccess(value) {
        this._externalEntropyAccess = value;
    }
    resetExternalEntropyAccess() {
        this._externalEntropyAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalEntropyAccessInput() {
        return this._externalEntropyAccess;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get maxLeaseTtlSeconds() {
        return this.getNumberAttribute('max_lease_ttl_seconds');
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get options() {
        return this.getStringMapAttribute('options');
    }
    set options(value) {
        this._options = value;
    }
    resetOptions() {
        this._options = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get optionsInput() {
        return this._options;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get sealWrap() {
        return this.getBooleanAttribute('seal_wrap');
    }
    set sealWrap(value) {
        this._sealWrap = value;
    }
    resetSealWrap() {
        this._sealWrap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sealWrapInput() {
        return this._sealWrap;
    }
    get cassandra() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('cassandra');
    }
    set cassandra(value) {
        this._cassandra = value;
    }
    resetCassandra() {
        this._cassandra = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cassandraInput() {
        return this._cassandra;
    }
    get couchbase() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('couchbase');
    }
    set couchbase(value) {
        this._couchbase = value;
    }
    resetCouchbase() {
        this._couchbase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get couchbaseInput() {
        return this._couchbase;
    }
    get elasticsearch() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('elasticsearch');
    }
    set elasticsearch(value) {
        this._elasticsearch = value;
    }
    resetElasticsearch() {
        this._elasticsearch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get elasticsearchInput() {
        return this._elasticsearch;
    }
    get hana() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('hana');
    }
    set hana(value) {
        this._hana = value;
    }
    resetHana() {
        this._hana = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hanaInput() {
        return this._hana;
    }
    get influxdb() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('influxdb');
    }
    set influxdb(value) {
        this._influxdb = value;
    }
    resetInfluxdb() {
        this._influxdb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get influxdbInput() {
        return this._influxdb;
    }
    get mongodb() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mongodb');
    }
    set mongodb(value) {
        this._mongodb = value;
    }
    resetMongodb() {
        this._mongodb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbInput() {
        return this._mongodb;
    }
    get mongodbatlas() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mongodbatlas');
    }
    set mongodbatlas(value) {
        this._mongodbatlas = value;
    }
    resetMongodbatlas() {
        this._mongodbatlas = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbatlasInput() {
        return this._mongodbatlas;
    }
    get mssql() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mssql');
    }
    set mssql(value) {
        this._mssql = value;
    }
    resetMssql() {
        this._mssql = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mssqlInput() {
        return this._mssql;
    }
    get mysql() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mysql');
    }
    set mysql(value) {
        this._mysql = value;
    }
    resetMysql() {
        this._mysql = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlInput() {
        return this._mysql;
    }
    get mysqlAurora() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mysql_aurora');
    }
    set mysqlAurora(value) {
        this._mysqlAurora = value;
    }
    resetMysqlAurora() {
        this._mysqlAurora = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlAuroraInput() {
        return this._mysqlAurora;
    }
    get mysqlLegacy() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mysql_legacy');
    }
    set mysqlLegacy(value) {
        this._mysqlLegacy = value;
    }
    resetMysqlLegacy() {
        this._mysqlLegacy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlLegacyInput() {
        return this._mysqlLegacy;
    }
    get mysqlRds() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('mysql_rds');
    }
    set mysqlRds(value) {
        this._mysqlRds = value;
    }
    resetMysqlRds() {
        this._mysqlRds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mysqlRdsInput() {
        return this._mysqlRds;
    }
    get oracle() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('oracle');
    }
    set oracle(value) {
        this._oracle = value;
    }
    resetOracle() {
        this._oracle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oracleInput() {
        return this._oracle;
    }
    get postgresql() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('postgresql');
    }
    set postgresql(value) {
        this._postgresql = value;
    }
    resetPostgresql() {
        this._postgresql = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get postgresqlInput() {
        return this._postgresql;
    }
    get redshift() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('redshift');
    }
    set redshift(value) {
        this._redshift = value;
    }
    resetRedshift() {
        this._redshift = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redshiftInput() {
        return this._redshift;
    }
    get snowflake() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('snowflake');
    }
    set snowflake(value) {
        this._snowflake = value;
    }
    resetSnowflake() {
        this._snowflake = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snowflakeInput() {
        return this._snowflake;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            audit_non_hmac_request_keys: cdktf.listMapper(cdktf.stringToTerraform)(this._auditNonHmacRequestKeys),
            audit_non_hmac_response_keys: cdktf.listMapper(cdktf.stringToTerraform)(this._auditNonHmacResponseKeys),
            default_lease_ttl_seconds: cdktf.numberToTerraform(this._defaultLeaseTtlSeconds),
            description: cdktf.stringToTerraform(this._description),
            external_entropy_access: cdktf.booleanToTerraform(this._externalEntropyAccess),
            local: cdktf.booleanToTerraform(this._local),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            options: cdktf.hashMapper(cdktf.stringToTerraform)(this._options),
            path: cdktf.stringToTerraform(this._path),
            seal_wrap: cdktf.booleanToTerraform(this._sealWrap),
            cassandra: cdktf.listMapper(databaseSecretsMountCassandraToTerraform)(this._cassandra),
            couchbase: cdktf.listMapper(databaseSecretsMountCouchbaseToTerraform)(this._couchbase),
            elasticsearch: cdktf.listMapper(databaseSecretsMountElasticsearchToTerraform)(this._elasticsearch),
            hana: cdktf.listMapper(databaseSecretsMountHanaToTerraform)(this._hana),
            influxdb: cdktf.listMapper(databaseSecretsMountInfluxdbToTerraform)(this._influxdb),
            mongodb: cdktf.listMapper(databaseSecretsMountMongodbToTerraform)(this._mongodb),
            mongodbatlas: cdktf.listMapper(databaseSecretsMountMongodbatlasToTerraform)(this._mongodbatlas),
            mssql: cdktf.listMapper(databaseSecretsMountMssqlToTerraform)(this._mssql),
            mysql: cdktf.listMapper(databaseSecretsMountMysqlToTerraform)(this._mysql),
            mysql_aurora: cdktf.listMapper(databaseSecretsMountMysqlAuroraToTerraform)(this._mysqlAurora),
            mysql_legacy: cdktf.listMapper(databaseSecretsMountMysqlLegacyToTerraform)(this._mysqlLegacy),
            mysql_rds: cdktf.listMapper(databaseSecretsMountMysqlRdsToTerraform)(this._mysqlRds),
            oracle: cdktf.listMapper(databaseSecretsMountOracleToTerraform)(this._oracle),
            postgresql: cdktf.listMapper(databaseSecretsMountPostgresqlToTerraform)(this._postgresql),
            redshift: cdktf.listMapper(databaseSecretsMountRedshiftToTerraform)(this._redshift),
            snowflake: cdktf.listMapper(databaseSecretsMountSnowflakeToTerraform)(this._snowflake),
        };
    }
}
exports.DatabaseSecretsMount = DatabaseSecretsMount;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecretsMount[_a] = { fqn: "hashicorp_vault.DatabaseSecretsMount", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
DatabaseSecretsMount.tfResourceType = "vault_database_secrets_mount";
//# sourceMappingURL=data:application/json;base64,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