import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseSecretBackendStaticRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Database Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#backend DatabaseSecretBackendStaticRole#backend}
    */
    readonly backend: string;
    /**
    * Database connection to use for this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#db_name DatabaseSecretBackendStaticRole#db_name}
    */
    readonly dbName: string;
    /**
    * Unique name for the static role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#name DatabaseSecretBackendStaticRole#name}
    */
    readonly name: string;
    /**
    * The amount of time Vault should wait before rotating the password, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#rotation_period DatabaseSecretBackendStaticRole#rotation_period}
    */
    readonly rotationPeriod: number;
    /**
    * Database statements to execute to rotate the password for the configured database user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#rotation_statements DatabaseSecretBackendStaticRole#rotation_statements}
    */
    readonly rotationStatements?: string[];
    /**
    * The database username that this role corresponds to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role#username DatabaseSecretBackendStaticRole#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role vault_database_secret_backend_static_role}
*/
export declare class DatabaseSecretBackendStaticRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_database_secret_backend_static_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_static_role vault_database_secret_backend_static_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseSecretBackendStaticRoleConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseSecretBackendStaticRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    get dbNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): number;
    set rotationPeriod(value: number);
    get rotationPeriodInput(): number | undefined;
    private _rotationStatements?;
    get rotationStatements(): string[];
    set rotationStatements(value: string[]);
    resetRotationStatements(): void;
    get rotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=database-secret-backend-static-role.d.ts.map