import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Database Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#backend DatabaseSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Database statements to execute to create and configure a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#creation_statements DatabaseSecretBackendRole#creation_statements}
    */
    readonly creationStatements: string[];
    /**
    * Database connection to use for this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#db_name DatabaseSecretBackendRole#db_name}
    */
    readonly dbName: string;
    /**
    * Default TTL for leases associated with this role, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#default_ttl DatabaseSecretBackendRole#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Maximum TTL for leases associated with this role, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#max_ttl DatabaseSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#name DatabaseSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Database statements to execute to renew a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#renew_statements DatabaseSecretBackendRole#renew_statements}
    */
    readonly renewStatements?: string[];
    /**
    * Database statements to execute to revoke a user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#revocation_statements DatabaseSecretBackendRole#revocation_statements}
    */
    readonly revocationStatements?: string[];
    /**
    * Database statements to execute to rollback a create operation in the event of an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role#rollback_statements DatabaseSecretBackendRole#rollback_statements}
    */
    readonly rollbackStatements?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role vault_database_secret_backend_role}
*/
export declare class DatabaseSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_database_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/database_secret_backend_role vault_database_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseSecretBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _creationStatements?;
    get creationStatements(): string[];
    set creationStatements(value: string[]);
    get creationStatementsInput(): string[] | undefined;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    get dbNameInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    get id(): string;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _renewStatements?;
    get renewStatements(): string[];
    set renewStatements(value: string[]);
    resetRenewStatements(): void;
    get renewStatementsInput(): string[] | undefined;
    private _revocationStatements?;
    get revocationStatements(): string[];
    set revocationStatements(value: string[]);
    resetRevocationStatements(): void;
    get revocationStatementsInput(): string[] | undefined;
    private _rollbackStatements?;
    get rollbackStatements(): string[];
    set rollbackStatements(value: string[]);
    resetRollbackStatements(): void;
    get rollbackStatementsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=database-secret-backend-role.d.ts.map