import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultTransitEncryptConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Transit secret backend the key belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt#backend DataVaultTransitEncrypt#backend}
    */
    readonly backend: string;
    /**
    * Specifies the context for key derivation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt#context DataVaultTransitEncrypt#context}
    */
    readonly context?: string;
    /**
    * Name of the encryption key to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt#key DataVaultTransitEncrypt#key}
    */
    readonly key: string;
    /**
    * The version of the key to use for encryption
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt#key_version DataVaultTransitEncrypt#key_version}
    */
    readonly keyVersion?: number;
    /**
    * Map of strings read from Vault.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt#plaintext DataVaultTransitEncrypt#plaintext}
    */
    readonly plaintext: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt vault_transit_encrypt}
*/
export declare class DataVaultTransitEncrypt extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_transit_encrypt";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/transit_encrypt vault_transit_encrypt} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultTransitEncryptConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultTransitEncryptConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get ciphertext(): string;
    private _context?;
    get context(): string;
    set context(value: string);
    resetContext(): void;
    get contextInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _keyVersion?;
    get keyVersion(): number;
    set keyVersion(value: number);
    resetKeyVersion(): void;
    get keyVersionInput(): number | undefined;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-transit-encrypt.d.ts.map