import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultTransitDecryptConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Transit secret backend the key belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#backend DataVaultTransitDecrypt#backend}
    */
    readonly backend: string;
    /**
    * Transit encrypted cipher text.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#ciphertext DataVaultTransitDecrypt#ciphertext}
    */
    readonly ciphertext: string;
    /**
    * Specifies the context for key derivation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#context DataVaultTransitDecrypt#context}
    */
    readonly context?: string;
    /**
    * Name of the decryption key to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt#key DataVaultTransitDecrypt#key}
    */
    readonly key: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt vault_transit_decrypt}
*/
export declare class DataVaultTransitDecrypt extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_transit_decrypt";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/transit_decrypt vault_transit_decrypt} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultTransitDecryptConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultTransitDecryptConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _ciphertext?;
    get ciphertext(): string;
    set ciphertext(value: string);
    get ciphertextInput(): string | undefined;
    private _context?;
    get context(): string;
    set context(value: string);
    resetContext(): void;
    get contextInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get plaintext(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-transit-decrypt.d.ts.map