import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultPolicyDocumentConfig extends cdktf.TerraformMetaArguments {
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#rule DataVaultPolicyDocument#rule}
    */
    readonly rule?: DataVaultPolicyDocumentRule[] | cdktf.IResolvable;
}
export interface DataVaultPolicyDocumentRuleAllowedParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#key DataVaultPolicyDocument#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#value DataVaultPolicyDocument#value}
    */
    readonly value: string[];
}
export declare function dataVaultPolicyDocumentRuleAllowedParameterToTerraform(struct?: DataVaultPolicyDocumentRuleAllowedParameter | cdktf.IResolvable): any;
export interface DataVaultPolicyDocumentRuleDeniedParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#key DataVaultPolicyDocument#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#value DataVaultPolicyDocument#value}
    */
    readonly value: string[];
}
export declare function dataVaultPolicyDocumentRuleDeniedParameterToTerraform(struct?: DataVaultPolicyDocumentRuleDeniedParameter | cdktf.IResolvable): any;
export interface DataVaultPolicyDocumentRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#capabilities DataVaultPolicyDocument#capabilities}
    */
    readonly capabilities: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#description DataVaultPolicyDocument#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#max_wrapping_ttl DataVaultPolicyDocument#max_wrapping_ttl}
    */
    readonly maxWrappingTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#min_wrapping_ttl DataVaultPolicyDocument#min_wrapping_ttl}
    */
    readonly minWrappingTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#path DataVaultPolicyDocument#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#required_parameters DataVaultPolicyDocument#required_parameters}
    */
    readonly requiredParameters?: string[];
    /**
    * allowed_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#allowed_parameter DataVaultPolicyDocument#allowed_parameter}
    */
    readonly allowedParameter?: DataVaultPolicyDocumentRuleAllowedParameter[] | cdktf.IResolvable;
    /**
    * denied_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/policy_document#denied_parameter DataVaultPolicyDocument#denied_parameter}
    */
    readonly deniedParameter?: DataVaultPolicyDocumentRuleDeniedParameter[] | cdktf.IResolvable;
}
export declare function dataVaultPolicyDocumentRuleToTerraform(struct?: DataVaultPolicyDocumentRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/policy_document vault_policy_document}
*/
export declare class DataVaultPolicyDocument extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_policy_document";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/policy_document vault_policy_document} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultPolicyDocumentConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultPolicyDocumentConfig);
    get hcl(): string;
    get id(): string;
    private _rule?;
    get rule(): DataVaultPolicyDocumentRule[] | cdktf.IResolvable;
    set rule(value: DataVaultPolicyDocumentRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | DataVaultPolicyDocumentRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-policy-document.d.ts.map