import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultNomadAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Nomad secret backend to generate tokens from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/nomad_access_token#backend DataVaultNomadAccessToken#backend}
    */
    readonly backend: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/nomad_access_token#role DataVaultNomadAccessToken#role}
    */
    readonly role: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/nomad_access_token vault_nomad_access_token}
*/
export declare class DataVaultNomadAccessToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_nomad_access_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/nomad_access_token vault_nomad_access_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultNomadAccessTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultNomadAccessTokenConfig);
    get accessorId(): string;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get id(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get secretId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-nomad-access-token.d.ts.map