"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVaultKubernetesAuthBackendConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config}
*/
class DataVaultKubernetesAuthBackendConfig extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKubernetesAuthBackendConfigConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_kubernetes_auth_backend_config',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._backend = config.backend;
        this._disableIssValidation = config.disableIssValidation;
        this._disableLocalCaJwt = config.disableLocalCaJwt;
        this._issuer = config.issuer;
        this._kubernetesCaCert = config.kubernetesCaCert;
        this._kubernetesHost = config.kubernetesHost;
        this._pemKeys = config.pemKeys;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get disableIssValidation() {
        return this.getBooleanAttribute('disable_iss_validation');
    }
    set disableIssValidation(value) {
        this._disableIssValidation = value;
    }
    resetDisableIssValidation() {
        this._disableIssValidation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableIssValidationInput() {
        return this._disableIssValidation;
    }
    get disableLocalCaJwt() {
        return this.getBooleanAttribute('disable_local_ca_jwt');
    }
    set disableLocalCaJwt(value) {
        this._disableLocalCaJwt = value;
    }
    resetDisableLocalCaJwt() {
        this._disableLocalCaJwt = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableLocalCaJwtInput() {
        return this._disableLocalCaJwt;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get kubernetesCaCert() {
        return this.getStringAttribute('kubernetes_ca_cert');
    }
    set kubernetesCaCert(value) {
        this._kubernetesCaCert = value;
    }
    resetKubernetesCaCert() {
        this._kubernetesCaCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesCaCertInput() {
        return this._kubernetesCaCert;
    }
    get kubernetesHost() {
        return this.getStringAttribute('kubernetes_host');
    }
    set kubernetesHost(value) {
        this._kubernetesHost = value;
    }
    resetKubernetesHost() {
        this._kubernetesHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kubernetesHostInput() {
        return this._kubernetesHost;
    }
    get pemKeys() {
        return this.getListAttribute('pem_keys');
    }
    set pemKeys(value) {
        this._pemKeys = value;
    }
    resetPemKeys() {
        this._pemKeys = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pemKeysInput() {
        return this._pemKeys;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            disable_iss_validation: cdktf.booleanToTerraform(this._disableIssValidation),
            disable_local_ca_jwt: cdktf.booleanToTerraform(this._disableLocalCaJwt),
            issuer: cdktf.stringToTerraform(this._issuer),
            kubernetes_ca_cert: cdktf.stringToTerraform(this._kubernetesCaCert),
            kubernetes_host: cdktf.stringToTerraform(this._kubernetesHost),
            pem_keys: cdktf.listMapper(cdktf.stringToTerraform)(this._pemKeys),
        };
    }
}
exports.DataVaultKubernetesAuthBackendConfig = DataVaultKubernetesAuthBackendConfig;
_a = JSII_RTTI_SYMBOL_1;
DataVaultKubernetesAuthBackendConfig[_a] = { fqn: "hashicorp_vault.DataVaultKubernetesAuthBackendConfig", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
DataVaultKubernetesAuthBackendConfig.tfResourceType = "vault_kubernetes_auth_backend_config";
//# sourceMappingURL=data:application/json;base64,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