import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityOidcOpenidConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config#name DataVaultIdentityOidcOpenidConfig#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config vault_identity_oidc_openid_config}
*/
export declare class DataVaultIdentityOidcOpenidConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_oidc_openid_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_openid_config vault_identity_oidc_openid_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityOidcOpenidConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultIdentityOidcOpenidConfigConfig);
    get authorizationEndpoint(): string;
    get grantTypesSupported(): string[];
    get id(): string;
    get idTokenSigningAlgValuesSupported(): string[];
    get issuer(): string;
    get jwksUri(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get requestUriParameterSupported(): cdktf.IResolvable;
    get responseTypesSupported(): string[];
    get scopesSupported(): string[];
    get subjectTypesSupported(): string[];
    get tokenEndpoint(): string;
    get tokenEndpointAuthMethodsSupported(): string[];
    get userinfoEndpoint(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-identity-oidc-openid-config.d.ts.map