import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_id DataVaultIdentityGroup#alias_id}
    */
    readonly aliasId?: string;
    /**
    * Accessor of the mount to which the alias belongs to. This should be supplied in conjunction with `alias_name`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_mount_accessor DataVaultIdentityGroup#alias_mount_accessor}
    */
    readonly aliasMountAccessor?: string;
    /**
    * Name of the alias. This should be supplied in conjunction with `alias_mount_accessor`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#alias_name DataVaultIdentityGroup#alias_name}
    */
    readonly aliasName?: string;
    /**
    * ID of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#group_id DataVaultIdentityGroup#group_id}
    */
    readonly groupId?: string;
    /**
    * Name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_group#group_name DataVaultIdentityGroup#group_name}
    */
    readonly groupName?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_group vault_identity_group}
*/
export declare class DataVaultIdentityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_group vault_identity_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultIdentityGroupConfig);
    get aliasCanonicalId(): string;
    get aliasCreationTime(): string;
    private _aliasId?;
    get aliasId(): string;
    set aliasId(value: string);
    resetAliasId(): void;
    get aliasIdInput(): string | undefined;
    get aliasLastUpdateTime(): string;
    get aliasMergedFromCanonicalIds(): string[];
    aliasMetadata(key: string): string | cdktf.IResolvable;
    private _aliasMountAccessor?;
    get aliasMountAccessor(): string;
    set aliasMountAccessor(value: string);
    resetAliasMountAccessor(): void;
    get aliasMountAccessorInput(): string | undefined;
    get aliasMountPath(): string;
    get aliasMountType(): string;
    private _aliasName?;
    get aliasName(): string;
    set aliasName(value: string);
    resetAliasName(): void;
    get aliasNameInput(): string | undefined;
    get creationTime(): string;
    get dataJson(): string;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    resetGroupName(): void;
    get groupNameInput(): string | undefined;
    get id(): string;
    get lastUpdateTime(): string;
    get memberEntityIds(): string[];
    get memberGroupIds(): string[];
    metadata(key: string): string | cdktf.IResolvable;
    get modifyIndex(): number;
    get namespaceId(): string;
    get parentGroupIds(): string[];
    get policies(): string[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-identity-group.d.ts.map