import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultGenericSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Full path from which a secret will be read.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/generic_secret#path DataVaultGenericSecret#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/generic_secret#version DataVaultGenericSecret#version}
    */
    readonly version?: number;
    /**
    * If set to true, stores 'lease_start_time' in the TF state.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/generic_secret#with_lease_start_time DataVaultGenericSecret#with_lease_start_time}
    */
    readonly withLeaseStartTime?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/generic_secret vault_generic_secret}
*/
export declare class DataVaultGenericSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_generic_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/generic_secret vault_generic_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultGenericSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultGenericSecretConfig);
    data(key: string): string | cdktf.IResolvable;
    get dataJson(): string;
    get id(): string;
    get leaseDuration(): number;
    get leaseId(): string;
    get leaseRenewable(): cdktf.IResolvable;
    get leaseStartTime(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _withLeaseStartTime?;
    get withLeaseStartTime(): boolean | cdktf.IResolvable;
    set withLeaseStartTime(value: boolean | cdktf.IResolvable);
    resetWithLeaseStartTime(): void;
    get withLeaseStartTimeInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-generic-secret.d.ts.map