"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataVaultAzureAccessCredentials = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials vault_azure_access_credentials}
*/
class DataVaultAzureAccessCredentials extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials vault_azure_access_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAzureAccessCredentialsConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_azure_access_credentials',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.6.0',
                providerVersionConstraint: '~> 3.6.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._backend = config.backend;
        this._environment = config.environment;
        this._maxCredValidationSeconds = config.maxCredValidationSeconds;
        this._numSecondsBetweenTests = config.numSecondsBetweenTests;
        this._numSequentialSuccesses = config.numSequentialSuccesses;
        this._role = config.role;
        this._subscriptionId = config.subscriptionId;
        this._tenantId = config.tenantId;
        this._validateCreds = config.validateCreds;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    // client_id - computed: true, optional: false, required: false
    get clientId() {
        return this.getStringAttribute('client_id');
    }
    // client_secret - computed: true, optional: false, required: false
    get clientSecret() {
        return this.getStringAttribute('client_secret');
    }
    get environment() {
        return this.getStringAttribute('environment');
    }
    set environment(value) {
        this._environment = value;
    }
    resetEnvironment() {
        this._environment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentInput() {
        return this._environment;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // lease_duration - computed: true, optional: false, required: false
    get leaseDuration() {
        return this.getNumberAttribute('lease_duration');
    }
    // lease_id - computed: true, optional: false, required: false
    get leaseId() {
        return this.getStringAttribute('lease_id');
    }
    // lease_renewable - computed: true, optional: false, required: false
    get leaseRenewable() {
        return this.getBooleanAttribute('lease_renewable');
    }
    // lease_start_time - computed: true, optional: false, required: false
    get leaseStartTime() {
        return this.getStringAttribute('lease_start_time');
    }
    get maxCredValidationSeconds() {
        return this.getNumberAttribute('max_cred_validation_seconds');
    }
    set maxCredValidationSeconds(value) {
        this._maxCredValidationSeconds = value;
    }
    resetMaxCredValidationSeconds() {
        this._maxCredValidationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxCredValidationSecondsInput() {
        return this._maxCredValidationSeconds;
    }
    get numSecondsBetweenTests() {
        return this.getNumberAttribute('num_seconds_between_tests');
    }
    set numSecondsBetweenTests(value) {
        this._numSecondsBetweenTests = value;
    }
    resetNumSecondsBetweenTests() {
        this._numSecondsBetweenTests = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numSecondsBetweenTestsInput() {
        return this._numSecondsBetweenTests;
    }
    get numSequentialSuccesses() {
        return this.getNumberAttribute('num_sequential_successes');
    }
    set numSequentialSuccesses(value) {
        this._numSequentialSuccesses = value;
    }
    resetNumSequentialSuccesses() {
        this._numSequentialSuccesses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get numSequentialSuccessesInput() {
        return this._numSequentialSuccesses;
    }
    get role() {
        return this.getStringAttribute('role');
    }
    set role(value) {
        this._role = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get subscriptionId() {
        return this.getStringAttribute('subscription_id');
    }
    set subscriptionId(value) {
        this._subscriptionId = value;
    }
    resetSubscriptionId() {
        this._subscriptionId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subscriptionIdInput() {
        return this._subscriptionId;
    }
    get tenantId() {
        return this.getStringAttribute('tenant_id');
    }
    set tenantId(value) {
        this._tenantId = value;
    }
    resetTenantId() {
        this._tenantId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tenantIdInput() {
        return this._tenantId;
    }
    get validateCreds() {
        return this.getBooleanAttribute('validate_creds');
    }
    set validateCreds(value) {
        this._validateCreds = value;
    }
    resetValidateCreds() {
        this._validateCreds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateCredsInput() {
        return this._validateCreds;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            environment: cdktf.stringToTerraform(this._environment),
            max_cred_validation_seconds: cdktf.numberToTerraform(this._maxCredValidationSeconds),
            num_seconds_between_tests: cdktf.numberToTerraform(this._numSecondsBetweenTests),
            num_sequential_successes: cdktf.numberToTerraform(this._numSequentialSuccesses),
            role: cdktf.stringToTerraform(this._role),
            subscription_id: cdktf.stringToTerraform(this._subscriptionId),
            tenant_id: cdktf.stringToTerraform(this._tenantId),
            validate_creds: cdktf.booleanToTerraform(this._validateCreds),
        };
    }
}
exports.DataVaultAzureAccessCredentials = DataVaultAzureAccessCredentials;
_a = JSII_RTTI_SYMBOL_1;
DataVaultAzureAccessCredentials[_a] = { fqn: "hashicorp_vault.DataVaultAzureAccessCredentials", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
DataVaultAzureAccessCredentials.tfResourceType = "vault_azure_access_credentials";
//# sourceMappingURL=data:application/json;base64,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