import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultAzureAccessCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Azure Secret Backend to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#backend DataVaultAzureAccessCredentials#backend}
    */
    readonly backend: string;
    /**
    * The Azure environment to use during credential validation.
  Defaults to the environment configured in the Vault backend.
  Some possible values: AzurePublicCloud, AzureGovernmentCloud
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#environment DataVaultAzureAccessCredentials#environment}
    */
    readonly environment?: string;
    /**
    * If 'validate_creds' is true, the number of seconds after which to give up validating credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#max_cred_validation_seconds DataVaultAzureAccessCredentials#max_cred_validation_seconds}
    */
    readonly maxCredValidationSeconds?: number;
    /**
    * If 'validate_creds' is true, the number of seconds to wait between each test of generated credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#num_seconds_between_tests DataVaultAzureAccessCredentials#num_seconds_between_tests}
    */
    readonly numSecondsBetweenTests?: number;
    /**
    * If 'validate_creds' is true, the number of sequential successes required to validate generated credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#num_sequential_successes DataVaultAzureAccessCredentials#num_sequential_successes}
    */
    readonly numSequentialSuccesses?: number;
    /**
    * Azure Secret Role to read credentials from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#role DataVaultAzureAccessCredentials#role}
    */
    readonly role: string;
    /**
    * The subscription ID to use during credential validation. Defaults to the subscription ID configured in the Vault backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#subscription_id DataVaultAzureAccessCredentials#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * The tenant ID to use during credential validation. Defaults to the tenant ID configured in the Vault backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#tenant_id DataVaultAzureAccessCredentials#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Whether generated credentials should be validated before being returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials#validate_creds DataVaultAzureAccessCredentials#validate_creds}
    */
    readonly validateCreds?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials vault_azure_access_credentials}
*/
export declare class DataVaultAzureAccessCredentials extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_azure_access_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/azure_access_credentials vault_azure_access_credentials} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAzureAccessCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultAzureAccessCredentialsConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get clientId(): string;
    get clientSecret(): string;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    resetEnvironment(): void;
    get environmentInput(): string | undefined;
    get id(): string;
    get leaseDuration(): number;
    get leaseId(): string;
    get leaseRenewable(): cdktf.IResolvable;
    get leaseStartTime(): string;
    private _maxCredValidationSeconds?;
    get maxCredValidationSeconds(): number;
    set maxCredValidationSeconds(value: number);
    resetMaxCredValidationSeconds(): void;
    get maxCredValidationSecondsInput(): number | undefined;
    private _numSecondsBetweenTests?;
    get numSecondsBetweenTests(): number;
    set numSecondsBetweenTests(value: number);
    resetNumSecondsBetweenTests(): void;
    get numSecondsBetweenTestsInput(): number | undefined;
    private _numSequentialSuccesses?;
    get numSequentialSuccesses(): number;
    set numSequentialSuccesses(value: number);
    resetNumSequentialSuccesses(): void;
    get numSequentialSuccessesInput(): number | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _validateCreds?;
    get validateCreds(): boolean | cdktf.IResolvable;
    set validateCreds(value: boolean | cdktf.IResolvable);
    resetValidateCreds(): void;
    get validateCredsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-azure-access-credentials.d.ts.map