import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The auth backend mount point.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/auth_backend#path DataVaultAuthBackend#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/auth_backend vault_auth_backend}
*/
export declare class DataVaultAuthBackend extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/auth_backend vault_auth_backend} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultAuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultAuthBackendConfig);
    get accessor(): string;
    get defaultLeaseTtlSeconds(): number;
    get description(): string;
    get id(): string;
    get listingVisibility(): string;
    get local(): cdktf.IResolvable;
    get maxLeaseTtlSeconds(): number;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-vault-auth-backend.d.ts.map